/*
 * Decompiled with CFR 0.152.
 */
package de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers;

import com.oracle.tools.packager.Log;
import de.dynamicfiles.projects.gradle.plugins.javafx.JavaFXGradlePluginExtension;
import de.dynamicfiles.projects.gradle.plugins.javafx.tasks.workers.JfxAbstractWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class JfxRunWorker
extends JfxAbstractWorker {
    public void jfxrun(Project project) {
        JavaFXGradlePluginExtension ext = (JavaFXGradlePluginExtension)project.getExtensions().getByType(JavaFXGradlePluginExtension.class);
        this.addDeployDirToSystemClassloader(project, ext);
        Log.setLogger((Log.Logger)new Log.Logger(ext.isVerbose()));
        project.getLogger().lifecycle("Running JavaFX Application");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getEnvironmentRelativeExecutablePath(ext.isUseEnvironmentRelativeExecutables()) + "java");
        Optional.ofNullable(ext.getRunJavaParameter()).ifPresent(runJavaParameter -> {
            if (runJavaParameter.trim().isEmpty()) {
                return;
            }
            command.add((String)runJavaParameter);
        });
        command.add("-jar");
        command.add(ext.getJfxMainAppJarName());
        Optional.ofNullable(ext.getRunAppParameter()).ifPresent(runAppParameter -> {
            if (runAppParameter.trim().isEmpty()) {
                return;
            }
            command.add((String)runAppParameter);
        });
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (!this.isGradleDaemonMode()) {
                pb.inheritIO();
            }
            if (ext.isVerbose()) {
                project.getLogger().lifecycle("Running command: " + String.join((CharSequence)" ", command));
            }
            pb.directory(this.getAbsoluteOrProjectRelativeFile(project, ext.getJfxAppOutputDir(), ext.isCheckForAbsolutePaths())).command(command);
            Process p = pb.start();
            if (this.isGradleDaemonMode()) {
                this.redirectIO(p, project.getLogger());
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new GradleException("There was an exception while executing JavaFX Application. Please check build-log.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new GradleException("There was an exception while executing JavaFX Application.", (Throwable)ex);
        }
    }
}

