/*
 * Decompiled with CFR 0.152.
 */
package de.idealo.spring.stream.binder.sqs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;

public class SnsFanoutMessageBuilderFactory
extends DefaultMessageBuilderFactory {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public <T> MessageBuilder<T> fromMessage(Message<T> message) {
        JsonNode jsonNode;
        try {
            jsonNode = this.objectMapper.readTree((String)message.getPayload());
        }
        catch (JsonProcessingException e) {
            throw new MessagingException(message, (Throwable)e);
        }
        if (!jsonNode.has("Type")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(jsonNode.get("Type").asText())) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' is not a valid notification", null);
        }
        if (!jsonNode.has("Message")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a message", null);
        }
        String messagePayload = jsonNode.get("Message").asText();
        return MessageBuilder.withPayload((Object)messagePayload).copyHeaders((Map)message.getHeaders());
    }
}

