/*
 * Decompiled with CFR 0.152.
 */
package de.idealo.spring.stream.binder.sqs;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import de.idealo.spring.stream.binder.sqs.SnsFanoutMessageBuilderFactory;
import de.idealo.spring.stream.binder.sqs.SqsPayloadConvertingChannelInterceptor;
import de.idealo.spring.stream.binder.sqs.inbound.SqsInboundChannelAdapter;
import de.idealo.spring.stream.binder.sqs.properties.SqsConsumerProperties;
import de.idealo.spring.stream.binder.sqs.properties.SqsExtendedBindingProperties;
import de.idealo.spring.stream.binder.sqs.properties.SqsProducerProperties;
import de.idealo.spring.stream.binder.sqs.provisioning.SqsStreamProvisioner;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.aws.outbound.SqsMessageHandler;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptor;

public class SqsMessageHandlerBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<SqsConsumerProperties>, ExtendedProducerProperties<SqsProducerProperties>, SqsStreamProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, SqsConsumerProperties, SqsProducerProperties> {
    private final AmazonSQSAsync amazonSQS;
    private final SqsExtendedBindingProperties extendedBindingProperties;
    private final List<SqsInboundChannelAdapter> adapters = new ArrayList<SqsInboundChannelAdapter>();

    public SqsMessageHandlerBinder(AmazonSQSAsync amazonSQS, SqsStreamProvisioner provisioningProvider, SqsExtendedBindingProperties extendedBindingProperties) {
        super(new String[0], (ProvisioningProvider)provisioningProvider);
        this.amazonSQS = amazonSQS;
        this.extendedBindingProperties = extendedBindingProperties;
    }

    public AmazonSQSAsync getAmazonSQS() {
        return this.amazonSQS;
    }

    public List<SqsInboundChannelAdapter> getAdapters() {
        return new ArrayList<SqsInboundChannelAdapter>(this.adapters);
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<SqsProducerProperties> producerProperties, MessageChannel errorChannel) throws Exception {
        SqsMessageHandler sqsMessageHandler = new SqsMessageHandler(this.amazonSQS);
        sqsMessageHandler.setQueue(destination.getName());
        sqsMessageHandler.setFailureChannel(errorChannel);
        sqsMessageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        sqsMessageHandler.setDelayExpressionString(String.format("headers.get('%s')", "sqs_delay"));
        sqsMessageHandler.setMessageGroupIdExpressionString(String.format("headers.get('%s')", "sqs_groupId"));
        sqsMessageHandler.setMessageDeduplicationIdExpressionString(String.format("headers.get('%s')", "sqs_deduplicationId"));
        return sqsMessageHandler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<SqsConsumerProperties> properties) throws Exception {
        SqsInboundChannelAdapter adapter = new SqsInboundChannelAdapter(this.amazonSQS, destination.getName());
        adapter.setMaxNumberOfMessages(((SqsConsumerProperties)properties.getExtension()).getMaxNumberOfMessages());
        adapter.setConcurrency(properties.getConcurrency());
        adapter.setVisibilityTimeout(((SqsConsumerProperties)properties.getExtension()).getVisibilityTimeout());
        adapter.setWaitTimeOut(((SqsConsumerProperties)properties.getExtension()).getWaitTimeout());
        if (((SqsConsumerProperties)properties.getExtension()).getQueueStopTimeout() != null) {
            adapter.setQueueStopTimeout(((SqsConsumerProperties)properties.getExtension()).getQueueStopTimeout());
        }
        if (((SqsConsumerProperties)properties.getExtension()).getMessageDeletionPolicy() != null) {
            adapter.setMessageDeletionPolicy(((SqsConsumerProperties)properties.getExtension()).getMessageDeletionPolicy());
        }
        if (((SqsConsumerProperties)properties.getExtension()).isSnsFanout()) {
            adapter.setMessageBuilderFactory((MessageBuilderFactory)new SnsFanoutMessageBuilderFactory());
        }
        this.adapters.add(adapter);
        return adapter;
    }

    public SqsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (SqsConsumerProperties)this.extendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public SqsProducerProperties getExtendedProducerProperties(String channelName) {
        return (SqsProducerProperties)this.extendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.extendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.extendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, ExtendedProducerProperties<SqsProducerProperties> producerProperties) {
        ((AbstractMessageChannel)outputChannel).addInterceptor((ChannelInterceptor)new SqsPayloadConvertingChannelInterceptor());
    }
}

