/*
 * Decompiled with CFR 0.152.
 */
package de.idealo.spring.stream.binder.sqs.inbound;

import com.amazonaws.services.sqs.AmazonSQSAsync;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.messaging.config.SimpleMessageListenerContainerFactory;
import io.awspring.cloud.messaging.listener.QueueMessageHandler;
import io.awspring.cloud.messaging.listener.SimpleMessageListenerContainer;
import io.awspring.cloud.messaging.listener.SqsMessageDeletionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Scope(value="prototype")
public class SqsInboundChannelAdapter
extends MessageProducerSupport {
    private final SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory = new SimpleMessageListenerContainerFactory();
    private final String[] queues;
    private final List<SimpleMessageListenerContainer> listenerContainers = new ArrayList<SimpleMessageListenerContainer>();
    private int concurrency = 1;
    private Long queueStopTimeout;
    private SqsMessageDeletionPolicy messageDeletionPolicy = SqsMessageDeletionPolicy.NO_REDRIVE;

    public SqsInboundChannelAdapter(AmazonSQSAsync amazonSqs, String ... queues) {
        Assert.noNullElements((Object[])queues, (String)"'queues' must not be empty");
        this.simpleMessageListenerContainerFactory.setAmazonSqs(amazonSqs);
        this.queues = Arrays.copyOf(queues, queues.length);
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.simpleMessageListenerContainerFactory.setTaskExecutor(taskExecutor);
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.simpleMessageListenerContainerFactory.setMaxNumberOfMessages(maxNumberOfMessages);
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.simpleMessageListenerContainerFactory.setVisibilityTimeout(visibilityTimeout);
    }

    public void setWaitTimeOut(Integer waitTimeOut) {
        this.simpleMessageListenerContainerFactory.setWaitTimeOut(waitTimeOut);
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.simpleMessageListenerContainerFactory.setResourceIdResolver(resourceIdResolver);
    }

    public void setAutoStartup(boolean autoStartUp) {
        super.setAutoStartup(autoStartUp);
        this.simpleMessageListenerContainerFactory.setAutoStartup(autoStartUp);
    }

    public void setDestinationResolver(DestinationResolver<String> destinationResolver) {
        this.simpleMessageListenerContainerFactory.setDestinationResolver(destinationResolver);
    }

    public void setQueueStopTimeout(long queueStopTimeout) {
        this.queueStopTimeout = queueStopTimeout;
    }

    public void setMessageDeletionPolicy(SqsMessageDeletionPolicy messageDeletionPolicy) {
        Assert.notNull((Object)messageDeletionPolicy, (String)"'messageDeletionPolicy' must not be null.");
        this.messageDeletionPolicy = messageDeletionPolicy;
    }

    protected void onInit() {
        super.onInit();
        for (int i = 0; i < this.concurrency; ++i) {
            SimpleMessageListenerContainer container = this.simpleMessageListenerContainerFactory.createSimpleMessageListenerContainer();
            this.listenerContainers.add(container);
            if (this.queueStopTimeout != null) {
                container.setQueueStopTimeout(this.queueStopTimeout.longValue());
            }
            container.setMessageHandler((QueueMessageHandler)new IntegrationQueueMessageHandler());
            try {
                container.afterPropertiesSet();
                continue;
            }
            catch (Exception e) {
                throw new BeanCreationException("Cannot instantiate 'SimpleMessageListenerContainer'", (Throwable)e);
            }
        }
    }

    protected void doStart() {
        super.doStart();
        this.listenerContainers.forEach(rec$ -> ((SimpleMessageListenerContainer)rec$).start());
    }

    protected void doStop() {
        super.doStop();
        this.listenerContainers.forEach(rec$ -> ((SimpleMessageListenerContainer)rec$).stop());
    }

    public boolean isRunning(String logicalQueueName) {
        return this.listenerContainers.stream().anyMatch(container -> container.isRunning(logicalQueueName));
    }

    public String[] getQueues() {
        return Arrays.copyOf(this.queues, this.queues.length);
    }

    public void destroy() {
        this.listenerContainers.forEach(rec$ -> ((SimpleMessageListenerContainer)rec$).destroy());
    }

    private class IntegrationQueueMessageHandler
    extends QueueMessageHandler {
        private IntegrationQueueMessageHandler() {
        }

        public Map<QueueMessageHandler.MappingInformation, HandlerMethod> getHandlerMethods() {
            HashSet<String> uniqueQueues = new HashSet<String>(Arrays.asList(SqsInboundChannelAdapter.this.queues));
            QueueMessageHandler.MappingInformation mappingInformation = new QueueMessageHandler.MappingInformation(uniqueQueues, SqsInboundChannelAdapter.this.messageDeletionPolicy);
            return Collections.singletonMap(mappingInformation, null);
        }

        protected void handleMessageInternal(Message<?> message, String lookupDestination) {
            MessageHeaders headers = message.getHeaders();
            Message messageToSend = SqsInboundChannelAdapter.this.getMessageBuilderFactory().fromMessage(message).removeHeaders(new String[]{"LogicalResourceId", "MessageId", "ReceiptHandle", "Acknowledgment"}).setHeader("aws_messageId", headers.get((Object)"MessageId")).setHeader("aws_receiptHandle", headers.get((Object)"ReceiptHandle")).setHeader("aws_receivedQueue", headers.get((Object)"LogicalResourceId")).setHeader("aws_acknowledgment", headers.get((Object)"Acknowledgment")).build();
            SqsInboundChannelAdapter.this.sendMessage(messageToSend);
        }
    }
}

