/* Copyright 2016 Sven van der Meer <vdmeer.sven@mykolab.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.vandermeer.skb.interfaces.strategies.maps.navigablemap;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

import de.vandermeer.skb.interfaces.strategies.maps.IsNavigableMapStrategy;

/**
 * Strategy for a concurrent skip list map (as navigable map).
 *
 * @author     Sven van der Meer &lt;vdmeer.sven@mykolab.com&gt;
 * @version    v0.0.1 build 170404 (04-Apr-17) for Java 1.8
 * @since      v0.0.1
 */
public interface ConcurrentSkipListMapStrategy<K extends Comparable<K>, V> extends IsNavigableMapStrategy<K, V> {

	@Override
	default ConcurrentSkipListMap<K, V> get() {
		return new ConcurrentSkipListMap<>();
	}

	@Override
	default ConcurrentSkipListMap<K, V> get(Map<K, V> map){
		return new ConcurrentSkipListMap<>(map);
	}

	/**
	 * Creates a new concurrent skip list map strategy.
	 * @param <K> type of the keys in the map
	 * @param <V> type of the values in the map
	 * @return concurrent skip list map strategy
	 */
	static <K extends Comparable<K>, V> ConcurrentSkipListMapStrategy<K, V> create(){
		return new ConcurrentSkipListMapStrategy<K, V>() {};
	}
}
