/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle;

import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.model.SubtitleParser;
import fr.noop.subtitle.model.SubtitleParsingException;
import fr.noop.subtitle.model.SubtitleWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;

public class Convert {
    private Options options = new Options();

    private void configureOptions() {
        this.options.addOption("h", "help", false, "print help");
        this.options.addOption(Option.builder((String)"i").required().longOpt("input-file").hasArg().desc("Input file").build());
        this.options.addOption(Option.builder((String)"o").required().longOpt("output-file").hasArg().desc("Output file").build());
        this.options.addOption(Option.builder((String)"ic").required(false).longOpt("input-charset").hasArg().desc("Input charset").build());
        this.options.addOption(Option.builder((String)"oc").required(false).longOpt("output-charset").hasArg().desc("Output charset").build());
    }

    public Convert() {
        this.configureOptions();
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("subtitle-convert", this.options);
    }

    public void run(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption('h')) {
                this.printHelp();
                System.exit(1);
            }
            String inputFilePath = line.getOptionValue("i");
            String outputFilePath = line.getOptionValue("o");
            String inputCharset = line.getOptionValue("ic", "utf-8");
            String outputCharset = line.getOptionValue("oc", "utf-8");
            SubtitleParser subtitleParser = null;
            try {
                subtitleParser = this.buildParser(inputFilePath, inputCharset);
            }
            catch (IOException e) {
                System.out.println(String.format("Unable to build parser for file %s: %s", inputFilePath, e.getMessage()));
                System.exit(1);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(inputFilePath);
            }
            catch (IOException e) {
                System.out.println(String.format("Input file %s does not exist: %s", inputFilePath, e.getMessage()));
                System.exit(1);
            }
            SubtitleObject inputSubtitle = null;
            try {
                inputSubtitle = subtitleParser.parse(is);
            }
            catch (IOException e) {
                System.out.println(String.format("Unable ro read input file %s: %s", inputFilePath, e.getMessage()));
                System.exit(1);
            }
            catch (SubtitleParsingException e) {
                System.out.println(String.format("Unable to parse input file %s;: %s", inputFilePath, e.getMessage()));
                System.exit(1);
            }
            SubtitleWriter writer = null;
            try {
                writer = this.buildWriter(outputFilePath, outputCharset);
            }
            catch (IOException e) {
                System.out.println(String.format("Unable to build writer for file %s: %s", outputFilePath, e.getMessage()));
                System.exit(1);
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(outputFilePath);
            }
            catch (IOException e) {
                System.out.println(String.format("Unable to create output file %s: %s", outputFilePath, e.getMessage()));
                System.exit(1);
            }
            try {
                writer.write(inputSubtitle, os);
            }
            catch (IOException e) {
                System.out.println(String.format("Unable to write output file %s: %s", outputFilePath, e.getMessage()));
                System.exit(1);
            }
        }
        catch (ParseException exp) {
            this.printHelp();
            System.exit(1);
        }
    }

    private SubtitleParser buildParser(String filePath, String charset) throws IOException {
        String ext = this.getFileExtension(filePath);
        ConvertFormat convertFormat = ConvertFormat.getEnum(ext);
        ConvertParser convertParser = ConvertParser.getEnum(convertFormat);
        try {
            Class<?> parserClass = Class.forName(convertParser.getClassName());
            if (convertParser.hasCharsetConstructor()) {
                return (SubtitleParser)parserClass.getConstructor(String.class).newInstance(charset);
            }
            return (SubtitleParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to instantiate class %s", convertParser.getClassName()));
        }
    }

    private SubtitleWriter buildWriter(String filePath, String charset) throws IOException {
        String ext = this.getFileExtension(filePath);
        ConvertFormat convertFormat = ConvertFormat.getEnum(ext);
        ConvertWriter convertWriter = ConvertWriter.getEnum(convertFormat);
        try {
            Class<?> writerClass = Class.forName(convertWriter.getClassName());
            if (convertWriter.hasCharsetConstructor()) {
                return (SubtitleWriter)writerClass.getConstructor(String.class).newInstance(charset);
            }
            return (SubtitleWriter)writerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to instantiate class %s", convertWriter.getClassName()));
        }
    }

    private String getFileExtension(String filePath) throws IOException {
        String ext = null;
        int i = filePath.lastIndexOf(46);
        if (i > 0) {
            ext = filePath.substring(i + 1);
        }
        if (ext == null) {
            throw new IOException("Unable to get file extension");
        }
        return ext;
    }

    public static void main(String[] args) {
        Convert convert = new Convert();
        convert.run(args);
    }

    private static enum ConvertWriter {
        SAMI(ConvertFormat.SAMI, "fr.noop.subtitle.sami.SamiWriter", true),
        VTT(ConvertFormat.VTT, "fr.noop.subtitle.vtt.VttWriter", true),
        SRT(ConvertFormat.SRT, "fr.noop.subtitle.srt.SrtWriter", true),
        TTML(ConvertFormat.TTML, "fr.noop.subtitle.ttml.TtmlWriter", false);

        private ConvertFormat format;
        private String className;
        private boolean charsetConstructor;

        private ConvertWriter(ConvertFormat format, String className, boolean charsetConstructor) {
            this.format = format;
            this.className = className;
            this.charsetConstructor = charsetConstructor;
        }

        public ConvertFormat getFormat() {
            return this.format;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean hasCharsetConstructor() {
            return this.charsetConstructor;
        }

        public static ConvertWriter getEnum(ConvertFormat format) {
            for (ConvertWriter v : ConvertWriter.values()) {
                if (v.getFormat() != format) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum ConvertParser {
        SAMI(ConvertFormat.SAMI, "fr.noop.subtitle.sami.SamiParser", true),
        VTT(ConvertFormat.VTT, "fr.noop.subtitle.vtt.VttParser", true),
        SRT(ConvertFormat.SRT, "fr.noop.subtitle.srt.SrtParser", true),
        STL(ConvertFormat.STL, "fr.noop.subtitle.stl.StlParser", false);

        private ConvertFormat format;
        private String className;
        private boolean charsetConstructor;

        private ConvertParser(ConvertFormat format, String className, boolean charsetConstructor) {
            this.format = format;
            this.className = className;
            this.charsetConstructor = charsetConstructor;
        }

        public ConvertFormat getFormat() {
            return this.format;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean hasCharsetConstructor() {
            return this.charsetConstructor;
        }

        public static ConvertParser getEnum(ConvertFormat format) {
            for (ConvertParser v : ConvertParser.values()) {
                if (v.getFormat() != format) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum ConvertFormat {
        TTML(new String[]{"xml"}),
        SAMI(new String[]{"smi"}),
        VTT(new String[]{"vtt"}),
        SRT(new String[]{"srt"}),
        STL(new String[]{"stl"});

        private String[] availableExtensions;

        private ConvertFormat(String[] availableExtensions) {
            this.availableExtensions = availableExtensions;
        }

        public String[] getAvailableExtensions() {
            return this.availableExtensions;
        }

        public static ConvertFormat getEnum(String extension) {
            for (ConvertFormat v : ConvertFormat.values()) {
                if (!ArrayUtils.contains((Object[])v.getAvailableExtensions(), (Object)extension)) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }
}

