/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.base;

import fr.noop.subtitle.model.SubtitleCue;
import fr.noop.subtitle.model.SubtitleLine;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSubtitleCue
implements SubtitleCue {
    private String id;
    private SubtitleTimeCode startTime;
    private SubtitleTimeCode endTime;
    private List<SubtitleLine> lines;

    protected BaseSubtitleCue(SubtitleCue cue) {
        this.id = cue.getId();
        this.startTime = cue.getStartTime();
        this.endTime = cue.getEndTime();
        this.lines = new ArrayList<SubtitleLine>(cue.getLines());
    }

    protected BaseSubtitleCue() {
        this.lines = new ArrayList<SubtitleLine>();
    }

    protected BaseSubtitleCue(SubtitleTimeCode startTime, SubtitleTimeCode endTime) {
        this.lines = new ArrayList<SubtitleLine>();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    protected BaseSubtitleCue(SubtitleTimeCode startTime, SubtitleTimeCode endTime, List<SubtitleLine> lines) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.lines = lines;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public SubtitleTimeCode getStartTime() {
        return this.startTime;
    }

    public void setStartTime(SubtitleTimeCode startTime) {
        this.startTime = startTime;
    }

    @Override
    public SubtitleTimeCode getEndTime() {
        return this.endTime;
    }

    public void setEndTime(SubtitleTimeCode endTime) {
        this.endTime = endTime;
    }

    @Override
    public List<SubtitleLine> getLines() {
        return this.lines;
    }

    public void setLines(List<SubtitleLine> lines) {
        this.lines = lines;
    }

    public void addLine(SubtitleLine line) {
        this.lines.add(line);
    }

    public void subtractTime(SubtitleTimeCode toSubtract) {
        this.setStartTime(this.getStartTime().subtract(toSubtract));
        this.setEndTime(this.getEndTime().subtract(toSubtract));
    }

    @Override
    public String getText() {
        CharSequence[] texts = new String[this.lines.size()];
        for (int i = 0; i < texts.length; ++i) {
            texts[i] = this.lines.get(i).toString();
        }
        return String.join((CharSequence)"\n", texts);
    }

    public String toString() {
        return this.getText();
    }
}

