/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.sami;

import fr.noop.subtitle.base.BaseSubtitleCue;
import fr.noop.subtitle.model.SubtitleParser;
import fr.noop.subtitle.model.SubtitleParsingException;
import fr.noop.subtitle.sami.SamiCue;
import fr.noop.subtitle.sami.SamiObject;
import fr.noop.subtitle.util.SubtitlePlainText;
import fr.noop.subtitle.util.SubtitleTextLine;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SamiParser
implements SubtitleParser {
    private String charset;

    public SamiParser(String charset) {
        this.charset = charset;
    }

    @Override
    public SamiObject parse(InputStream is) throws IOException, SubtitleParsingException {
        SamiObject samiObject = new SamiObject();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, this.charset));
        String textLine = "";
        CursorStatus cursorStatus = CursorStatus.NONE;
        BaseSubtitleCue cue = null;
        BaseSubtitleCue previousCue = null;
        while ((textLine = br.readLine()) != null) {
            String text;
            String lcTextLine = (textLine = textLine.trim()).toLowerCase();
            if (lcTextLine.startsWith("</body>") || cursorStatus == CursorStatus.BODY_END) {
                cursorStatus = CursorStatus.BODY_END;
                continue;
            }
            if (cursorStatus == CursorStatus.NONE) {
                if (!lcTextLine.startsWith("<body>")) continue;
                cursorStatus = CursorStatus.BODY_START;
                continue;
            }
            if (cursorStatus == CursorStatus.BODY_START) {
                if (textLine.isEmpty()) continue;
                if (!lcTextLine.startsWith("<sync")) {
                    throw new SubtitleParsingException(String.format("Unexpected time code: %s", textLine));
                }
            }
            if (cursorStatus == CursorStatus.BODY_START || cursorStatus == CursorStatus.CUE_TEXT && lcTextLine.startsWith("<sync")) {
                long time;
                text = textLine.substring(5).trim();
                if (!text.toLowerCase().startsWith("start=")) {
                    throw new SubtitleParsingException(String.format("Unexpected time code: %s", textLine));
                }
                String startTime = text.substring(6, text.length() - 1).trim();
                try {
                    time = Long.valueOf(startTime);
                }
                catch (NumberFormatException e) {
                    throw new SubtitleParsingException(String.format("Unable to parse start time: %s", textLine));
                }
                cue = new SamiCue();
                cue.setStartTime(new SubtitleTimeCode(time));
                if (previousCue != null) {
                    previousCue.setEndTime(new SubtitleTimeCode(time));
                }
                samiObject.addCue(cue);
                previousCue = cue;
                cursorStatus = CursorStatus.CUE_TIMECODE;
                continue;
            }
            if (cursorStatus == CursorStatus.CUE_TIMECODE || cursorStatus == CursorStatus.CUE_TEXT) {
                text = textLine;
                if (lcTextLine.startsWith("<p")) {
                    text = text.substring(text.indexOf(">") + 1);
                }
                if (lcTextLine.endsWith("</p>")) {
                    text = text.substring(0, text.length() - 4);
                }
                SubtitleTextLine line = new SubtitleTextLine();
                line.addText(new SubtitlePlainText(text));
                cue.addLine(line);
                cursorStatus = CursorStatus.CUE_TEXT;
                continue;
            }
            throw new SubtitleParsingException(String.format("Unexpected line: %s", textLine));
        }
        if (previousCue != null) {
            previousCue.setEndTime(new SubtitleTimeCode(previousCue.getStartTime().getTime() + 2000L));
        }
        return samiObject;
    }

    private static enum CursorStatus {
        NONE,
        BODY_START,
        BODY_END,
        CUE_TIMECODE,
        CUE_TEXT;

    }
}

