/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.sami;

import fr.noop.subtitle.model.SubtitleCue;
import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.model.SubtitleWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SamiWriter
implements SubtitleWriter {
    private String charset;

    public SamiWriter(String charset) {
        this.charset = charset;
    }

    @Override
    public void write(SubtitleObject subtitleObject, OutputStream os) throws IOException {
        try {
            os.write(new String("<SAMI>\n").getBytes(this.charset));
            this.writeCues(subtitleObject, os);
            os.write(new String("</SAMI>\n").getBytes(this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Encoding error in input subtitle");
        }
    }

    private void writeHeader(SubtitleObject subtitleObject, OutputStream os) throws IOException {
        os.write(new String("<Head>\n").getBytes(this.charset));
        if (subtitleObject.hasProperty(SubtitleObject.Property.TITLE)) {
            os.write(String.format("  <Title>%s</Title>\n", subtitleObject.getProperty(SubtitleObject.Property.TITLE)).getBytes(this.charset));
        }
        os.write(new String("</Head>\n").getBytes(this.charset));
    }

    private void writeCues(SubtitleObject subtitleObject, OutputStream os) throws IOException {
        os.write(new String("<Body>\n").getBytes(this.charset));
        for (SubtitleCue cue : subtitleObject.getCues()) {
            os.write(String.format("  <SYNC Start=%d>\n", cue.getStartTime().getTime()).getBytes(this.charset));
            os.write(String.format("    <P>%s\n", cue.getText()).getBytes(this.charset));
        }
        os.write(new String("</Body>\n").getBytes(this.charset));
    }
}

