/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.srt;

import fr.noop.subtitle.model.SubtitleParser;
import fr.noop.subtitle.model.SubtitleParsingException;
import fr.noop.subtitle.srt.SrtCue;
import fr.noop.subtitle.srt.SrtObject;
import fr.noop.subtitle.util.SubtitlePlainText;
import fr.noop.subtitle.util.SubtitleTextLine;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SrtParser
implements SubtitleParser {
    private String charset;

    public SrtParser(String charset) {
        this.charset = charset;
    }

    @Override
    public SrtObject parse(InputStream is) throws IOException, SubtitleParsingException {
        SrtObject srtObject = new SrtObject();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, this.charset));
        String textLine = "";
        CursorStatus cursorStatus = CursorStatus.NONE;
        SrtCue cue = null;
        while ((textLine = br.readLine()) != null) {
            textLine = textLine.trim();
            if (cursorStatus == CursorStatus.NONE) {
                if (textLine.isEmpty()) continue;
                cue = new SrtCue();
                try {
                    Integer.parseInt(textLine);
                }
                catch (NumberFormatException e) {
                    throw new SubtitleParsingException(String.format("Unable to parse cue number: %s", textLine));
                }
                cue.setId(textLine);
                cursorStatus = CursorStatus.CUE_ID;
                continue;
            }
            if (cursorStatus == CursorStatus.CUE_ID) {
                if (!textLine.substring(13, 16).equals("-->")) {
                    throw new SubtitleParsingException(String.format("Timecode textLine is badly formated: %s", textLine));
                }
                cue.setStartTime(this.parseTimeCode(textLine.substring(0, 12)));
                cue.setEndTime(this.parseTimeCode(textLine.substring(17)));
                cursorStatus = CursorStatus.CUE_TIMECODE;
                continue;
            }
            if (!(textLine.isEmpty() || cursorStatus != CursorStatus.CUE_TIMECODE && cursorStatus != CursorStatus.CUE_TEXT)) {
                SubtitleTextLine line = new SubtitleTextLine();
                line.addText(new SubtitlePlainText(textLine));
                cue.addLine(line);
                cursorStatus = CursorStatus.CUE_TEXT;
                continue;
            }
            if (cursorStatus == CursorStatus.CUE_TEXT && textLine.isEmpty()) {
                srtObject.addCue(cue);
                cue = null;
                cursorStatus = CursorStatus.NONE;
                continue;
            }
            throw new SubtitleParsingException(String.format("Unexpected line: %s", textLine));
        }
        return srtObject;
    }

    private SubtitleTimeCode parseTimeCode(String timeCodeString) throws SubtitleParsingException {
        try {
            int hour = Integer.parseInt(timeCodeString.substring(0, 2));
            int minute = Integer.parseInt(timeCodeString.substring(3, 5));
            int second = Integer.parseInt(timeCodeString.substring(6, 8));
            int millisecond = Integer.parseInt(timeCodeString.substring(9, 12));
            return new SubtitleTimeCode(hour, minute, second, millisecond);
        }
        catch (NumberFormatException e) {
            throw new SubtitleParsingException(String.format("Unable to parse time code: %s", timeCodeString));
        }
    }

    private static enum CursorStatus {
        NONE,
        CUE_ID,
        CUE_TIMECODE,
        CUE_TEXT;

    }
}

