/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.stl;

import fr.noop.subtitle.base.BaseSubtitleCue;
import fr.noop.subtitle.model.SubtitleRegionCue;
import fr.noop.subtitle.stl.StlTti;
import fr.noop.subtitle.util.SubtitlePlainText;
import fr.noop.subtitle.util.SubtitleRegion;
import fr.noop.subtitle.util.SubtitleStyle;
import fr.noop.subtitle.util.SubtitleStyledText;
import fr.noop.subtitle.util.SubtitleTextLine;
import java.util.ArrayList;
import java.util.List;

public class StlCue
extends BaseSubtitleCue
implements SubtitleRegionCue {
    private List<StlTti> ttis = new ArrayList<StlTti>();
    SubtitleRegion region;

    public StlCue(StlTti tti) {
        super(tti.getTci(), tti.getTco());
        this.addTti(tti);
    }

    public List<StlTti> getTtis() {
        return this.ttis;
    }

    public void addTti(StlTti tti) {
        this.ttis.add(tti);
        this.addText(tti);
    }

    private void addText(StlTti tti) {
        String tf = tti.getTf();
        for (String tfPart : tf.split("\u008a")) {
            SubtitleTextLine line = new SubtitleTextLine();
            SubtitleStyle textStyle = null;
            String text = null;
            boolean startText = false;
            int cIndex = 0;
            while (cIndex < tfPart.length()) {
                char cc = tfPart.charAt(cIndex);
                int cByte = cc & 0xFF;
                ++cIndex;
                if (text == null) {
                    text = new String();
                    textStyle = new SubtitleStyle();
                    startText = tti.getJc() == StlTti.Jc.NONE;
                }
                if (cByte == 11) {
                    startText = true;
                }
                if (cByte >= 8 && cByte <= 9 || cByte >= 11 && cByte <= 15 || cByte >= 24 && cByte <= 31 || cByte >= 134 && cByte <= 143 || cByte == 128 || cByte == 130 || cByte == 132) continue;
                if (cByte >= 0 && cByte <= 7 || cByte >= 16 && cByte <= 23) {
                    textStyle.setColor(StlTti.TextColor.getEnum(cByte).getColor());
                    continue;
                }
                if (text == null) continue;
                if (cByte == 10 || cByte == 129 || cByte == 131 || cByte == 133) {
                    if (!textStyle.hasProperties()) {
                        textStyle = null;
                    }
                    if (text != null && !text.isEmpty()) {
                        if (textStyle == null) {
                            line.addText(new SubtitlePlainText(text));
                        } else {
                            line.addText(new SubtitleStyledText(text, textStyle));
                        }
                    }
                    text = null;
                    textStyle = null;
                    continue;
                }
                if (!startText) continue;
                text = text + cc;
            }
            if (line.isEmpty()) continue;
            this.addLine(line);
        }
    }

    public boolean isEmpty() {
        return this.getText().isEmpty();
    }

    @Override
    public SubtitleRegion getRegion() {
        return this.region;
    }

    public void setRegion(SubtitleRegion region) {
        this.region = region;
    }
}

