/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.stl;

import fr.noop.subtitle.base.BaseSubtitleObject;
import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.stl.StlCue;
import fr.noop.subtitle.stl.StlGsi;
import fr.noop.subtitle.stl.StlTti;
import fr.noop.subtitle.util.SubtitleRegion;
import java.util.ArrayList;
import java.util.List;

public class StlObject
extends BaseSubtitleObject {
    private StlGsi gsi;
    List<StlTti> ttis = new ArrayList<StlTti>();

    public StlObject(StlGsi gsi) {
        this.setProperty(SubtitleObject.Property.TITLE, gsi.getOpt());
        this.setProperty(SubtitleObject.Property.FRAME_RATE, gsi.getDfc().getFrameRate());
        this.gsi = gsi;
    }

    public StlGsi getGsi() {
        return this.gsi;
    }

    public void setGsi(StlGsi gsi) {
        this.gsi = gsi;
    }

    public List<StlTti> getTtis() {
        return this.ttis;
    }

    public void setTtis(List<StlTti> ttis) {
        this.ttis = ttis;
    }

    public void addTti(StlTti tti) {
        this.ttis.add(tti);
        StlCue cue = new StlCue(tti);
        if (cue.isEmpty()) {
            return;
        }
        cue.subtractTime(this.gsi.getTcf());
        float rowHeight = 100.0f / (float)this.gsi.getMnr();
        int newVp = tti.getVp() + 2 * (cue.getLines().size() - 1);
        SubtitleRegion region = new SubtitleRegion(0.0f, 100.0f - (float)(this.gsi.getMnr() - newVp) * rowHeight);
        cue.setRegion(region);
        this.addCue(cue);
    }
}

