/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.stl;

import fr.noop.subtitle.model.SubtitleParser;
import fr.noop.subtitle.model.SubtitleParsingException;
import fr.noop.subtitle.stl.StlGsi;
import fr.noop.subtitle.stl.StlObject;
import fr.noop.subtitle.stl.StlTti;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class StlParser
implements SubtitleParser {
    @Override
    public StlObject parse(InputStream is) throws SubtitleParsingException {
        StlObject stl;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            StlGsi gsi = this.readGsi(dis);
            stl = new StlObject(gsi);
        }
        catch (IOException e) {
            throw new SubtitleParsingException("Unable to parse Gsi block");
        }
        int subtitleIndex = 0;
        while (subtitleIndex++ < stl.getGsi().getTnb()) {
            StlTti tti;
            try {
                tti = this.readTti(dis, stl.getGsi());
            }
            catch (IOException e) {
                throw new SubtitleParsingException("Unable to parse tti block");
            }
            stl.addTti(tti);
        }
        return stl;
    }

    private Date readDate(String dateString) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            throw new IOException("Unable to parse date");
        }
    }

    private SubtitleTimeCode readTimeCode(String timeCodeString, int frameRate) throws IOException {
        int hour = Integer.parseInt(timeCodeString.substring(0, 2));
        int minute = Integer.parseInt(timeCodeString.substring(2, 4));
        int second = Integer.parseInt(timeCodeString.substring(4, 6));
        int frame = Integer.parseInt(timeCodeString.substring(6, 8));
        int frameDuration = 1000 / frameRate;
        return new SubtitleTimeCode(hour, minute, second, frame * frameDuration);
    }

    private SubtitleTimeCode readTimeCode(DataInputStream dis, int frameRate) throws IOException {
        int hour = dis.readUnsignedByte();
        int minute = dis.readUnsignedByte();
        int second = dis.readUnsignedByte();
        int frame = dis.readUnsignedByte();
        int frameDuration = 1000 / frameRate;
        return new SubtitleTimeCode(hour, minute, second, frame * frameDuration);
    }

    private String readString(DataInputStream dis, int length, String charset) throws IOException {
        byte[] bytes = new byte[length];
        dis.readFully(bytes, 0, length);
        return StringUtils.strip((String)new String(bytes, charset));
    }

    private String readString(DataInputStream dis, int length) throws IOException {
        byte[] bytes = new byte[length];
        dis.readFully(bytes, 0, length);
        return StringUtils.strip((String)new String(bytes));
    }

    private StlGsi readGsi(DataInputStream dis) throws IOException {
        StlGsi gsi = new StlGsi();
        byte[] cpnBytes = new byte[3];
        dis.readFully(cpnBytes, 0, 3);
        int cpn = cpnBytes[0] << 16 | cpnBytes[1] << 8 | cpnBytes[2];
        gsi.setCpn(StlGsi.Cpn.getEnum(cpn));
        gsi.setDfc(StlGsi.Dfc.getEnum(this.readString(dis, 8)));
        gsi.setDsc(StlGsi.Dsc.getEnum(dis.readUnsignedByte()));
        gsi.setCct(StlGsi.Cct.getEnum(Short.reverseBytes(dis.readShort())));
        gsi.setLc(Short.reverseBytes(dis.readShort()));
        gsi.setOpt(this.readString(dis, 32));
        gsi.setOet(this.readString(dis, 32));
        gsi.setTpt(this.readString(dis, 32));
        gsi.setTet(this.readString(dis, 32));
        gsi.setTn(this.readString(dis, 32));
        gsi.setTcd(this.readString(dis, 32));
        gsi.setSlr(this.readString(dis, 16));
        gsi.setCd(this.readDate(this.readString(dis, 6)));
        gsi.setRd(this.readDate(this.readString(dis, 6)));
        gsi.setRn(Short.reverseBytes(dis.readShort()));
        gsi.setTnb(Integer.parseInt(this.readString(dis, 5)));
        gsi.setTns(Integer.parseInt(this.readString(dis, 5)));
        dis.skipBytes(3);
        gsi.setMnc(Integer.parseInt(this.readString(dis, 2)));
        gsi.setMnr(Integer.parseInt(this.readString(dis, 2)));
        gsi.setTcs((short)dis.readUnsignedByte());
        gsi.setTcp(this.readTimeCode(this.readString(dis, 8), gsi.getDfc().getFrameRate()));
        gsi.setTcf(this.readTimeCode(this.readString(dis, 8), gsi.getDfc().getFrameRate()));
        gsi.setTnd((short)dis.readUnsignedByte());
        gsi.setDsn((short)dis.readUnsignedByte());
        gsi.setCo(this.readString(dis, 3));
        gsi.setPub(this.readString(dis, 32));
        gsi.setEn(this.readString(dis, 32));
        gsi.setEcd(this.readString(dis, 32));
        dis.skipBytes(75);
        gsi.setUda(this.readString(dis, 576));
        return gsi;
    }

    private StlTti readTti(DataInputStream dis, StlGsi gsi) throws IOException {
        String charset = gsi.getCct().getCharset();
        int frameRate = gsi.getDfc().getFrameRate();
        StlTti tti = new StlTti();
        tti.setSgn((short)dis.readUnsignedByte());
        tti.setSn(Short.reverseBytes(dis.readShort()));
        tti.setEbn((short)dis.readUnsignedByte());
        tti.setCs((short)dis.readUnsignedByte());
        tti.setTci(this.readTimeCode(dis, frameRate));
        tti.setTco(this.readTimeCode(dis, frameRate));
        tti.setVp((short)dis.readUnsignedByte());
        tti.setJc(StlTti.Jc.getEnum(dis.readUnsignedByte()));
        tti.setCf((short)dis.readUnsignedByte());
        byte[] tfBytes = new byte[112];
        dis.readFully(tfBytes, 0, 112);
        tti.setTf(new String(tfBytes, charset));
        return tti;
    }
}

