/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.ttml;

import fr.noop.subtitle.base.BaseSubtitleObject;
import fr.noop.subtitle.model.SubtitleCue;
import fr.noop.subtitle.model.SubtitleLine;
import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.model.SubtitleText;
import fr.noop.subtitle.ttml.TtmlCue;
import fr.noop.subtitle.util.SubtitleRegion;
import fr.noop.subtitle.util.SubtitleStyle;
import fr.noop.subtitle.util.SubtitleStyledText;
import java.util.HashMap;
import java.util.Map;

public class TtmlObject
extends BaseSubtitleObject {
    private Map<String, String> styleMapping = new HashMap<String, String>();
    private Map<String, SubtitleStyle> styles = new HashMap<String, SubtitleStyle>();
    private Map<String, String> regionMapping = new HashMap<String, String>();
    private Map<String, SubtitleRegion> regions = new HashMap<String, SubtitleRegion>();

    public TtmlObject() {
    }

    public TtmlObject(SubtitleObject subtitleObject) {
        for (Map.Entry<SubtitleObject.Property, Object> entry : subtitleObject.getProperties().entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        for (int cueIndex = 0; cueIndex < subtitleObject.getCues().size(); ++cueIndex) {
            SubtitleCue cue = subtitleObject.getCues().get(cueIndex);
            TtmlCue ttmlCue = new TtmlCue(cue);
            SubtitleRegion region = ttmlCue.getRegion();
            String regionSignature = this.buildRegionSignature(region);
            if (!this.regionMapping.containsKey(regionSignature)) {
                String regionId = String.format("region-%d", this.regions.size() + 1);
                this.regionMapping.put(regionSignature, regionId);
                this.regions.put(regionId, new SubtitleRegion(region));
            }
            for (SubtitleLine line : ttmlCue.getLines()) {
                for (SubtitleText text : line.getTexts()) {
                    SubtitleStyle style;
                    String styleSignature;
                    if (!(text instanceof SubtitleStyledText) || this.styleMapping.containsKey(styleSignature = this.buildStyleSignature(style = ((SubtitleStyledText)text).getStyle()))) continue;
                    String styleId = String.format("style-%d", this.styles.size() + 1);
                    this.styleMapping.put(styleSignature, styleId);
                    this.styles.put(styleId, new SubtitleStyle(style));
                }
            }
            ttmlCue.setId(String.format("cue-%d", cueIndex + 1));
            this.addCue(ttmlCue);
        }
    }

    private String buildRegionSignature(SubtitleRegion region) {
        return String.format("%d-%d-%d-%d-%s", new Object[]{(int)(region.getX() * 100.0f), (int)(region.getY() * 100.0f), (int)(region.getWidth() * 100.0f), (int)(region.getHeight() * 100.0f), region.getVerticalAlign()});
    }

    private String buildStyleSignature(SubtitleStyle style) {
        return String.format("%s-%s-%s-%s-%s", style.getProperty(SubtitleStyle.Property.DIRECTION), style.getProperty(SubtitleStyle.Property.TEXT_ALIGN), style.getProperty(SubtitleStyle.Property.COLOR), style.getProperty(SubtitleStyle.Property.FONT_STYLE), style.getProperty(SubtitleStyle.Property.FONT_WEIGHT), style.getProperty(SubtitleStyle.Property.TEXT_DECORATION));
    }

    public String getStyleId(SubtitleStyle style) {
        String styleSignature = this.buildStyleSignature(style);
        return this.styleMapping.getOrDefault(styleSignature, null);
    }

    public String getRegionId(SubtitleRegion region) {
        String regionSignature = this.buildRegionSignature(region);
        return this.regionMapping.getOrDefault(regionSignature, null);
    }

    public Map<String, SubtitleStyle> getStyles() {
        return this.styles;
    }

    public void setStyle(String styleId, SubtitleStyle style) {
        this.styleMapping.put(this.buildStyleSignature(style), styleId);
        this.styles.put(styleId, style);
    }

    public Map<String, SubtitleRegion> getRegions() {
        return this.regions;
    }

    public void setRegion(String regionId, SubtitleRegion region) {
        this.regionMapping.put(this.buildRegionSignature(region), regionId);
        this.regions.put(regionId, region);
    }
}

