/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.ttml;

import fr.noop.subtitle.model.SubtitleCue;
import fr.noop.subtitle.model.SubtitleLine;
import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.model.SubtitleText;
import fr.noop.subtitle.model.SubtitleWriter;
import fr.noop.subtitle.ttml.TtmlCue;
import fr.noop.subtitle.ttml.TtmlObject;
import fr.noop.subtitle.util.SubtitleRegion;
import fr.noop.subtitle.util.SubtitleStyle;
import fr.noop.subtitle.util.SubtitleStyledText;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TtmlWriter
implements SubtitleWriter {
    private static final String NS_TT = "http://www.w3.org/ns/ttml";
    private static final String NS_TTP = "http://www.w3.org/ns/ttml#parameter";
    private static final String NS_TTM = "http://www.w3.org/ns/ttml#metadata";
    private static final String NS_TTS = "http://www.w3.org/ns/ttml#styling";
    private static final String NS_XML = "http://www.w3.org/XML/1998/namespace";

    @Override
    public void write(SubtitleObject subtitleObject, OutputStream os) {
        TtmlObject ttmlObject = new TtmlObject(subtitleObject);
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            StringWriter sw = new StringWriter();
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(sw);
            xsw.writeStartDocument("utf-8", "1.0");
            xsw.setPrefix("tt", NS_TT);
            xsw.setPrefix("ttp", NS_TTP);
            xsw.setPrefix("tts", NS_TTS);
            xsw.setPrefix("ttm", NS_TTM);
            xsw.setPrefix("xml", NS_XML);
            xsw.writeStartElement("tt");
            xsw.writeDefaultNamespace(NS_TT);
            xsw.writeNamespace("tt", NS_TT);
            xsw.writeNamespace("ttp", NS_TTP);
            xsw.writeNamespace("tts", NS_TTS);
            xsw.writeNamespace("ttm", NS_TTM);
            xsw.writeNamespace("xml", NS_XML);
            if (ttmlObject.hasProperty(SubtitleObject.Property.FRAME_RATE)) {
                xsw.writeAttribute(NS_TTP, "frameRate", String.valueOf(ttmlObject.getProperty(SubtitleObject.Property.FRAME_RATE)));
            }
            xsw.writeStartElement("head");
            this.writeMetadata(ttmlObject, xsw);
            this.writeStyles(ttmlObject, xsw);
            this.writeRegions(ttmlObject, xsw);
            xsw.writeEndElement();
            this.writeCues(ttmlObject, xsw);
            xsw.writeEndElement();
            byte[] bytes = sw.toString().getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            StreamSource ss = new StreamSource(is);
            StreamResult sr = new StreamResult(os);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(ss, sr);
            }
            catch (TransformerConfigurationException transformer) {
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void writeMetadata(TtmlObject ttmlObject, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("metadata");
        xsw.writeStartElement(NS_TTM, "title");
        xsw.writeCharacters((String)ttmlObject.getProperty(SubtitleObject.Property.TITLE));
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    private void writeStyles(TtmlObject ttmlObject, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("styling");
        for (Map.Entry<String, SubtitleStyle> entry : ttmlObject.getStyles().entrySet()) {
            SubtitleStyle style = entry.getValue();
            String styleId = entry.getKey();
            xsw.writeStartElement("style");
            xsw.writeAttribute(NS_XML, "id", styleId);
            if (style.getColor() != null) {
                xsw.writeAttribute(NS_TTS, "color", style.getColor());
            }
            if (style.getTextAlign() != null) {
                String textAlign = "center";
                if (style.getTextAlign() == SubtitleStyle.TextAlign.LEFT) {
                    textAlign = "left";
                } else if (style.getTextAlign() == SubtitleStyle.TextAlign.RIGHT) {
                    textAlign = "right";
                }
                xsw.writeAttribute(NS_TTS, "textAlign", textAlign);
            }
            if (style.getDirection() != null) {
                String direction = "ltr";
                if (style.getDirection() == SubtitleStyle.Direction.RTL) {
                    direction = "rtl";
                }
                xsw.writeAttribute(NS_TTS, "direction", direction);
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    private void writeRegions(TtmlObject ttmlObject, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("layout");
        for (Map.Entry<String, SubtitleRegion> entry : ttmlObject.getRegions().entrySet()) {
            SubtitleRegion region = entry.getValue();
            String regionId = entry.getKey();
            xsw.writeStartElement("region");
            xsw.writeAttribute(NS_XML, "id", regionId);
            xsw.writeAttribute(NS_TTS, "origin", String.format(Locale.US, "0%% %.2f%%", Float.valueOf(region.getY())));
            xsw.writeAttribute(NS_TTS, "extent", String.format(Locale.US, "100%% %.2f%%", Float.valueOf(region.getHeight())));
            xsw.writeAttribute(NS_TTS, "displayAlign", "after");
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    private void writeCues(TtmlObject ttmlObject, XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("body");
        xsw.writeStartElement("div");
        for (SubtitleCue cue : ttmlObject.getCues()) {
            TtmlCue ttmlCue = (TtmlCue)cue;
            xsw.writeStartElement("p");
            xsw.writeAttribute(NS_XML, "id", ttmlCue.getId());
            if (ttmlCue.getRegion() != null) {
                xsw.writeAttribute("region", ttmlObject.getRegionId(ttmlCue.getRegion()));
            }
            xsw.writeAttribute("begin", this.formatTimeCode(ttmlCue.getStartTime()));
            xsw.writeAttribute("end", this.formatTimeCode(ttmlCue.getEndTime()));
            int lineIndex = 0;
            for (SubtitleLine line : ttmlCue.getLines()) {
                ++lineIndex;
                for (SubtitleText text : line.getTexts()) {
                    xsw.writeStartElement("span");
                    if (text instanceof SubtitleStyledText) {
                        xsw.writeAttribute("style", ttmlObject.getStyleId(((SubtitleStyledText)text).getStyle()));
                    }
                    xsw.writeCharacters(text.toString());
                    xsw.writeEndElement();
                }
                if (lineIndex >= ttmlCue.getLines().size()) continue;
                xsw.writeStartElement("br");
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    private String formatTimeCode(SubtitleTimeCode timeCode) {
        return String.format("%02d:%02d:%02d.%03d", timeCode.getHour(), timeCode.getMinute(), timeCode.getSecond(), timeCode.getMillisecond());
    }
}

