/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.util;

import java.security.InvalidParameterException;

public class SubtitleRegion {
    private float x;
    private float y;
    private float width;
    private float height;
    private VerticalAlign verticalAlign;

    public SubtitleRegion(SubtitleRegion subtitleRegion) {
        this.x = subtitleRegion.getX();
        this.y = subtitleRegion.getY();
        this.width = subtitleRegion.getWidth();
        this.height = subtitleRegion.getHeight();
        this.verticalAlign = subtitleRegion.getVerticalAlign();
    }

    public SubtitleRegion(float y, float height) {
        this(0.0f, y, 100.0f, height, VerticalAlign.BOTTOM);
    }

    public SubtitleRegion(float y, float height, VerticalAlign verticalAlign) {
        this(0.0f, y, 100.0f, height, verticalAlign);
    }

    public SubtitleRegion(float x, float y, float width, float height) {
        this(x, y, width, height, VerticalAlign.BOTTOM);
    }

    public SubtitleRegion(float x, float y, float width, float height, VerticalAlign verticalAlign) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.verticalAlign = verticalAlign;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        if (x < 0.0f || x > 100.0f) {
            throw new InvalidParameterException("X value must be defined in percentage between 0 and 100");
        }
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        if (y < 0.0f || y > 100.0f) {
            throw new InvalidParameterException("Y value must be defined in percentage between 0 and 100");
        }
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SubtitleRegion)) {
            return false;
        }
        SubtitleRegion region = (SubtitleRegion)object;
        return this.getX() == region.getX() && this.getY() == region.getY() && this.getWidth() == region.getWidth() && this.getHeight() == region.getHeight() && this.getVerticalAlign() == region.getVerticalAlign();
    }

    public static enum VerticalAlign {
        TOP,
        BOTTOM;

    }
}

