/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.util;

import java.util.HashMap;
import java.util.Map;

public class SubtitleStyle {
    private Map<Property, Object> properties = new HashMap<Property, Object>();

    public SubtitleStyle() {
    }

    public SubtitleStyle(SubtitleStyle subtitleStyle) {
        for (Map.Entry<Property, Object> entry : subtitleStyle.getProperties().entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public Direction getDirection() {
        return (Direction)((Object)this.getProperty(Property.DIRECTION));
    }

    public void setDirection(Direction direction) {
        this.setProperty(Property.DIRECTION, (Object)direction);
    }

    public TextAlign getTextAlign() {
        return (TextAlign)((Object)this.getProperty(Property.TEXT_ALIGN));
    }

    public void setTextAlign(TextAlign textAlign) {
        this.setProperty(Property.TEXT_ALIGN, (Object)textAlign);
    }

    public String getColor() {
        return (String)this.getProperty(Property.COLOR);
    }

    public void setColor(String color) {
        this.setProperty(Property.COLOR, color);
    }

    public FontStyle getFontStyle() {
        return (FontStyle)((Object)this.getProperty(Property.FONT_STYLE));
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.setProperty(Property.FONT_STYLE, (Object)fontStyle);
    }

    public TextDecoration getTextDecoration() {
        return (TextDecoration)((Object)this.getProperty(Property.TEXT_DECORATION));
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.setProperty(Property.TEXT_DECORATION, (Object)textDecoration);
    }

    public Map<Property, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<Property, Object> properties) {
        this.properties = properties;
    }

    public void setProperty(Property property, Object value) {
        this.properties.put(property, value);
    }

    public Object getProperty(Property property) {
        return this.properties.get((Object)property);
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public String buildSignature() {
        return "none";
    }

    public static enum FontWeight {
        NORMAL,
        BOLD;

    }

    public static enum FontStyle {
        NORMAL,
        ITALIC,
        OBLIQUE;

    }

    public static enum TextAlign {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum TextDecoration {
        NONE,
        UNDERLINE,
        OVERLINE,
        LINE_THROUGH;

    }

    public static enum Direction {
        LTR,
        RTL;

    }

    public static enum Property {
        DIRECTION,
        TEXT_ALIGN,
        COLOR,
        FONT_STYLE,
        FONT_WEIGHT,
        TEXT_DECORATION;

    }
}

