/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.util;

import java.security.InvalidParameterException;
import java.time.LocalTime;

public class SubtitleTimeCode
implements Comparable<SubtitleTimeCode> {
    private final int MS_HOUR = 3600000;
    private final int MS_MINUTE = 60000;
    private final int MS_SECOND = 1000;
    private int hour;
    private int minute;
    private int second;
    private int millisecond;

    public SubtitleTimeCode(int hour, int minute, int second, int millisecond) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(millisecond);
    }

    public SubtitleTimeCode(LocalTime time) {
        this(time.getHour(), time.getMinute(), time.getSecond(), 0);
    }

    public SubtitleTimeCode(long time) {
        this.hour = (int)(time / 3600000L);
        this.minute = (int)((time - (long)(this.hour * 3600000)) / 60000L);
        this.second = (int)((time - (long)(this.hour * 3600000 + this.minute * 60000)) / 1000L);
        this.millisecond = (int)(time - (long)(this.hour * 3600000 + this.minute * 60000 + this.second * 1000));
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%03d", this.hour, this.minute, this.second, this.millisecond);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0) {
            throw new InvalidParameterException("Hour value must be greater or equal to 0");
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new InvalidParameterException("Minute value must be between 0 and 59");
        }
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second < 0 || second > 59) {
            throw new InvalidParameterException("A second value must be between 0 and 59");
        }
        this.second = second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void setMillisecond(int millisecond) {
        if (millisecond < 0 || millisecond > 999) {
            throw new InvalidParameterException("A Millisecond value must be between 0 and 999");
        }
        this.millisecond = millisecond;
    }

    public long getTime() {
        return this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.getMillisecond();
    }

    @Override
    public int compareTo(SubtitleTimeCode toCompare) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this.getTime() == toCompare.getTime()) {
            return 0;
        }
        if (this.getTime() > toCompare.getTime()) {
            return 1;
        }
        return -1;
    }

    public SubtitleTimeCode subtract(SubtitleTimeCode toSubtract) {
        return new SubtitleTimeCode(this.getTime() - toSubtract.getTime());
    }
}

