/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.vtt;

import fr.noop.subtitle.model.SubtitleLine;
import fr.noop.subtitle.model.SubtitleParser;
import fr.noop.subtitle.model.SubtitleParsingException;
import fr.noop.subtitle.util.SubtitlePlainText;
import fr.noop.subtitle.util.SubtitleStyle;
import fr.noop.subtitle.util.SubtitleStyledText;
import fr.noop.subtitle.util.SubtitleTimeCode;
import fr.noop.subtitle.vtt.VttCue;
import fr.noop.subtitle.vtt.VttLine;
import fr.noop.subtitle.vtt.VttObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class VttParser
implements SubtitleParser {
    private String charset;

    public VttParser(String charset) {
        this.charset = charset;
    }

    @Override
    public VttObject parse(InputStream is) throws IOException, SubtitleParsingException {
        VttObject vttObject = new VttObject();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, this.charset));
        String textLine = "";
        CursorStatus cursorStatus = CursorStatus.NONE;
        VttCue cue = null;
        String cueText = "";
        while ((textLine = br.readLine()) != null) {
            textLine = textLine.trim();
            if (cursorStatus == CursorStatus.NONE && textLine.equals("WEBVTT")) {
                cursorStatus = CursorStatus.SIGNATURE;
                continue;
            }
            if (cursorStatus == CursorStatus.SIGNATURE || cursorStatus == CursorStatus.EMPTY_LINE) {
                if (textLine.isEmpty()) continue;
                cue = new VttCue();
                cursorStatus = CursorStatus.CUE_ID;
                if (!textLine.substring(13, 16).equals("-->")) {
                    cue.setId(textLine);
                    continue;
                }
            }
            if (cursorStatus == CursorStatus.CUE_ID) {
                if (!textLine.substring(13, 16).equals("-->")) {
                    throw new SubtitleParsingException(String.format("Timecode textLine is badly formated: %s", textLine));
                }
                cue.setStartTime(this.parseTimeCode(textLine.substring(0, 12)));
                cue.setEndTime(this.parseTimeCode(textLine.substring(17)));
                cursorStatus = CursorStatus.CUE_TIMECODE;
                continue;
            }
            if (!(textLine.isEmpty() || cursorStatus != CursorStatus.CUE_TIMECODE && cursorStatus != CursorStatus.CUE_TEXT)) {
                if (!cueText.isEmpty()) {
                    cueText = cueText + "\n";
                }
                cueText = cueText + textLine;
                cursorStatus = CursorStatus.CUE_TEXT;
                continue;
            }
            if (cursorStatus == CursorStatus.CUE_TEXT && textLine.isEmpty()) {
                cue.setLines(this.parseCueText(cueText));
                vttObject.addCue(cue);
                cue = null;
                cueText = "";
                cursorStatus = CursorStatus.EMPTY_LINE;
                continue;
            }
            throw new SubtitleParsingException(String.format("Unexpected line: %s", textLine));
        }
        return vttObject;
    }

    private List<SubtitleLine> parseCueText(String cueText) {
        String text = "";
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<SubtitleLine> cueLines = new ArrayList<SubtitleLine>();
        VttLine cueLine = null;
        for (int i = 0; i < cueText.length(); ++i) {
            String textEnd;
            String tag = null;
            TagStatus tagStatus = TagStatus.NONE;
            char c = cueText.charAt(i);
            if (c != '\n') {
                text = text + c;
            }
            if ((textEnd = text.substring(Math.max(0, text.length() - 3), text.length())).equals("<b>") || textEnd.equals("<u>") || textEnd.equals("<i>") || textEnd.equals("<v ") || textEnd.equals("<c.") || textEnd.equals("<c ")) {
                tag = String.valueOf(textEnd.charAt(1));
                tagStatus = TagStatus.OPEN;
                tags.add(tag);
                text = text.substring(0, text.length() - 3);
            } else if (c == '>') {
                tagStatus = TagStatus.CLOSE;
                tag = (String)tags.remove(tags.size() - 1);
                int closeTagLength = 1;
                if (textEnd.charAt(0) == '/') {
                    closeTagLength = 4;
                }
                text = text.substring(0, text.length() - closeTagLength);
            } else if (c != '\n' && i < cueText.length() - 1) continue;
            if (c != '\n' && text.isEmpty()) continue;
            if (cueLine == null) {
                cueLine = new VttLine();
            }
            SubtitleStyle style = new SubtitleStyle();
            ArrayList<String> analyzedTags = new ArrayList<String>();
            analyzedTags.addAll(tags);
            if (tagStatus == TagStatus.CLOSE) {
                analyzedTags.add(tag);
            } else if (tagStatus == TagStatus.OPEN) {
                analyzedTags.remove(tags.size() - 1);
            }
            for (String analyzedTag : analyzedTags) {
                if (analyzedTag.equals("v")) {
                    cueLine.setVoice(text);
                    text = "";
                    break;
                }
                if (analyzedTag.equals("b")) {
                    style.setProperty(SubtitleStyle.Property.FONT_WEIGHT, (Object)SubtitleStyle.FontWeight.BOLD);
                    continue;
                }
                if (analyzedTag.equals("i")) {
                    style.setProperty(SubtitleStyle.Property.FONT_STYLE, (Object)SubtitleStyle.FontStyle.ITALIC);
                    continue;
                }
                if (analyzedTag.equals("u")) {
                    style.setProperty(SubtitleStyle.Property.TEXT_DECORATION, (Object)SubtitleStyle.TextDecoration.UNDERLINE);
                    continue;
                }
                if (!analyzedTag.equals("c") || tagStatus != TagStatus.CLOSE || !tag.equals("c") || textEnd.equals("/c>")) continue;
                text = "";
                tags.add(tag);
            }
            if (!text.isEmpty()) {
                if (style.hasProperties()) {
                    cueLine.addText(new SubtitleStyledText(text, style));
                } else {
                    cueLine.addText(new SubtitlePlainText(text));
                }
            }
            if (c == '\n' || i == cueText.length() - 1) {
                cueLines.add(cueLine);
                cueLine = null;
            }
            text = "";
        }
        return cueLines;
    }

    private SubtitleTimeCode parseTimeCode(String timeCodeString) throws SubtitleParsingException {
        try {
            int hour = Integer.parseInt(timeCodeString.substring(0, 2));
            int minute = Integer.parseInt(timeCodeString.substring(3, 5));
            int second = Integer.parseInt(timeCodeString.substring(6, 8));
            int millisecond = Integer.parseInt(timeCodeString.substring(9, 12));
            return new SubtitleTimeCode(hour, minute, second, millisecond);
        }
        catch (NumberFormatException e) {
            throw new SubtitleParsingException(String.format("Unable to parse time code: %s", timeCodeString));
        }
    }

    private static enum TagStatus {
        NONE,
        OPEN,
        CLOSE;

    }

    private static enum CursorStatus {
        NONE,
        SIGNATURE,
        EMPTY_LINE,
        CUE_ID,
        CUE_TIMECODE,
        CUE_TEXT;

    }
}

