/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.subtitle.vtt;

import fr.noop.subtitle.model.SubtitleCue;
import fr.noop.subtitle.model.SubtitleObject;
import fr.noop.subtitle.model.SubtitleWriter;
import fr.noop.subtitle.util.SubtitleTimeCode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class VttWriter
implements SubtitleWriter {
    private String charset;

    public VttWriter(String charset) {
        this.charset = charset;
    }

    @Override
    public void write(SubtitleObject subtitleObject, OutputStream os) throws IOException {
        try {
            os.write(new String("WEBVTT\n\n").getBytes(this.charset));
            for (SubtitleCue cue : subtitleObject.getCues()) {
                if (cue.getId() != null) {
                    String number = String.format("%s\n", cue.getId());
                    os.write(number.getBytes(this.charset));
                }
                String startToEnd = String.format("%s --> %s \n", this.formatTimeCode(cue.getStartTime()), this.formatTimeCode(cue.getEndTime()));
                os.write(startToEnd.getBytes(this.charset));
                String text = String.format("%s\n", cue.getText());
                os.write(text.getBytes(this.charset));
                os.write("\n".getBytes(this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Encoding error in input subtitle");
        }
    }

    private String formatTimeCode(SubtitleTimeCode timeCode) {
        return String.format("%02d:%02d:%02d.%03d", timeCode.getHour(), timeCode.getMinute(), timeCode.getSecond(), timeCode.getMillisecond());
    }
}

