/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.env.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class AmazonEc2InstanceDataPropertySource
extends EnumerablePropertySource<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonEc2InstanceDataPropertySource.class);
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static final String DEFAULT_USER_DATA_ATTRIBUTE_SEPARATOR = ";";
    private static final String DEFAULT_KNOWN_PROPERTIES_PATH = AmazonEc2InstanceDataPropertySource.class.getSimpleName() + ".properties";
    private static final Properties KNOWN_PROPERTY_NAMES;
    private String userDataAttributeSeparator = ";";
    private String userDataValueSeparator = ":";
    private volatile Map<String, String> cachedUserData;

    public AmazonEc2InstanceDataPropertySource(String name) {
        super(name, new Object());
    }

    private static String getRootPropertyName(String propertyName) {
        String[] propertyTokens = StringUtils.split((String)propertyName, (String)"/");
        return propertyTokens != null ? propertyTokens[0] : propertyName;
    }

    public void setUserDataAttributeSeparator(String userDataAttributeSeparator) {
        this.userDataAttributeSeparator = userDataAttributeSeparator;
    }

    public void setUserDataValueSeparator(String userDataValueSeparator) {
        this.userDataValueSeparator = userDataValueSeparator;
    }

    public Object getProperty(String name) {
        Map<String, String> userData = this.getUserData();
        if (userData.containsKey(name)) {
            return userData.get(name);
        }
        if (!KNOWN_PROPERTY_NAMES.containsKey(AmazonEc2InstanceDataPropertySource.getRootPropertyName(name))) {
            return null;
        }
        try {
            return EC2MetadataUtils.getData((String)("/latest/meta-data/" + name));
        }
        catch (AmazonClientException e) {
            LOGGER.warn("Error getting instance meta-data with name '{}' error message is '{}'", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    private Map<String, String> getUserData() {
        if (this.cachedUserData == null) {
            LinkedHashMap<String, String> userDataMap = new LinkedHashMap<String, String>();
            String userData = null;
            try {
                userData = EC2MetadataUtils.getUserData();
            }
            catch (AmazonClientException e) {
                LOGGER.warn("Error getting instance user-data error message is '{}'", (Object)e.getMessage());
            }
            if (StringUtils.hasText((String)userData)) {
                String[] userDataAttributes;
                for (String userDataAttribute : userDataAttributes = userData.split(this.userDataAttributeSeparator)) {
                    String[] userDataAttributesParts = StringUtils.split((String)userDataAttribute, (String)this.userDataValueSeparator);
                    if (userDataAttributesParts == null || userDataAttributesParts.length <= 0) continue;
                    String key = userDataAttributesParts[0];
                    String value = null;
                    if (userDataAttributesParts.length > 1) {
                        value = userDataAttributesParts[1];
                    }
                    userDataMap.put(key, value);
                }
            }
            this.cachedUserData = Collections.unmodifiableMap(userDataMap);
        }
        return this.cachedUserData;
    }

    public String[] getPropertyNames() {
        int count = KNOWN_PROPERTY_NAMES.size();
        Enumeration<Object> keys = KNOWN_PROPERTY_NAMES.keys();
        String[] keysArr = new String[count];
        for (int index = 0; keys.hasMoreElements() && index < count; ++index) {
            keysArr[index] = keys.nextElement().toString();
        }
        return keysArr;
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_KNOWN_PROPERTIES_PATH, AmazonEc2InstanceDataPropertySource.class);
            KNOWN_PROPERTY_NAMES = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load '" + DEFAULT_KNOWN_PROPERTIES_PATH + "': " + ex.getMessage());
        }
    }
}

