/*
 * Decompiled with CFR 0.152.
 */
package coil3;

import coil3.Uri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001aL\u0010\u0000\u001a\u00020\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003\u001a:\u0010\t\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u0007\u001a \u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001a\u0010\u0018\u001a\u00020\u0019*\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Uri", "Lcoil3/Uri;", "scheme", "", "authority", "path", "query", "fragment", "separator", "buildData", "pathSegments", "", "getPathSegments", "(Lcoil3/Uri;)Ljava/util/List;", "filePath", "getFilePath", "(Lcoil3/Uri;)Ljava/lang/String;", "toUri", "parseUri", "data", "original", "percentDecode", "bytes", "", "length", "", "getLength", "(Ljava/lang/String;)I", "coil-core"})
public final class UriKt {
    @NotNull
    public static final Uri Uri(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String query, @Nullable String fragment, @NotNull String separator) {
        if (!(scheme != null || authority != null || path != null || query != null || fragment != null)) {
            boolean bl = false;
            String string = "At least one of scheme, authority, path, query, or fragment must be non-null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Uri(UriKt.buildData(scheme, authority, path, query, fragment), separator, scheme, authority, path, query, fragment);
    }

    public static /* synthetic */ Uri Uri$default(String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = Path.DIRECTORY_SEPARATOR;
        }
        return UriKt.Uri(string, string2, string3, string4, string5, string6);
    }

    private static final String buildData(String scheme, String authority, String path, String query, String fragment) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildData_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (scheme != null) {
            $this$buildData_u24lambda_u241.append(scheme);
            $this$buildData_u24lambda_u241.append(':');
        }
        if (authority != null) {
            $this$buildData_u24lambda_u241.append("//");
            $this$buildData_u24lambda_u241.append(authority);
        }
        if (path != null) {
            $this$buildData_u24lambda_u241.append(path);
        }
        if (query != null) {
            $this$buildData_u24lambda_u241.append('?');
            $this$buildData_u24lambda_u241.append(query);
        }
        if (fragment != null) {
            $this$buildData_u24lambda_u241.append('#');
            $this$buildData_u24lambda_u241.append(fragment);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final List<String> getPathSegments(@NotNull Uri $this$pathSegments) {
        String string = $this$pathSegments.getPath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String path = string;
        List segments = new ArrayList();
        int index = -1;
        while (index < path.length()) {
            String segment;
            int startIndex = index + 1;
            if ((index = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)startIndex, (boolean)false, (int)4, null)) == -1) {
                index = path.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)path.substring(startIndex, index), (String)"substring(...)");
            if (!(((CharSequence)segment).length() > 0)) continue;
            ((Collection)segments).add(segment);
        }
        return segments;
    }

    @Nullable
    public static final String getFilePath(@NotNull Uri $this$filePath) {
        List<String> pathSegments = UriKt.getPathSegments($this$filePath);
        if (pathSegments.isEmpty()) {
            return null;
        }
        String string = $this$filePath.getPath();
        Intrinsics.checkNotNull((Object)string);
        String prefix = StringsKt.startsWith$default((String)string, (String)$this$filePath.getSeparator(), (boolean)false, (int)2, null) ? $this$filePath.getSeparator() : "";
        String string2 = $this$filePath.getSeparator();
        return CollectionsKt.joinToString$default((Iterable)pathSegments, (CharSequence)string2, (CharSequence)prefix, null, (int)0, null, null, (int)60, null);
    }

    @JvmOverloads
    @NotNull
    public static final Uri toUri(@NotNull String $this$toUri, @NotNull String separator) {
        String data = $this$toUri;
        if (!Intrinsics.areEqual((Object)separator, (Object)"/")) {
            data = StringsKt.replace$default((String)data, (String)separator, (String)"/", (boolean)false, (int)4, null);
        }
        return UriKt.parseUri(data, $this$toUri, separator);
    }

    public static /* synthetic */ Uri toUri$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = Path.DIRECTORY_SEPARATOR;
        }
        return UriKt.toUri(string, string2);
    }

    private static final Uri parseUri(String data, String original, String separator) {
        boolean openScheme = true;
        int schemeEndIndex = -1;
        int authorityStartIndex = -1;
        int pathStartIndex = -1;
        int queryStartIndex = -1;
        int fragmentStartIndex = -1;
        block6: for (int index = 0; index < data.length(); ++index) {
            switch (data.charAt(index)) {
                case ':': {
                    if (!openScheme || queryStartIndex != -1 || fragmentStartIndex != -1) continue block6;
                    if (index + 2 < original.length() && original.charAt(index + 1) == '/' && original.charAt(index + 2) == '/') {
                        openScheme = false;
                        schemeEndIndex = index;
                        authorityStartIndex = index + 3;
                        index += 2;
                        continue block6;
                    }
                    if (!Intrinsics.areEqual((Object)data, (Object)original)) continue block6;
                    schemeEndIndex = index;
                    authorityStartIndex = index + 1;
                    pathStartIndex = index + 1;
                    ++index;
                    continue block6;
                }
                case '/': {
                    if (pathStartIndex != -1 || queryStartIndex != -1 || fragmentStartIndex != -1) continue block6;
                    openScheme = false;
                    pathStartIndex = authorityStartIndex == -1 ? 0 : index;
                    continue block6;
                }
                case '?': {
                    if (queryStartIndex != -1 || fragmentStartIndex != -1) continue block6;
                    queryStartIndex = index + 1;
                    continue block6;
                }
                case '#': {
                    if (fragmentStartIndex != -1) continue block6;
                    fragmentStartIndex = index + 1;
                }
            }
        }
        String scheme = null;
        String authority = null;
        String path = null;
        String query = null;
        String fragment = null;
        int queryEndIndex = Math.min(fragmentStartIndex == -1 ? Integer.MAX_VALUE : fragmentStartIndex - 1, data.length());
        int pathEndIndex = Math.min(queryStartIndex == -1 ? Integer.MAX_VALUE : queryStartIndex - 1, queryEndIndex);
        if (authorityStartIndex != -1) {
            String string = data.substring(0, schemeEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            scheme = string;
            int authorityEndIndex = Math.min(pathStartIndex == -1 ? Integer.MAX_VALUE : pathStartIndex, pathEndIndex);
            String string2 = data.substring(authorityStartIndex, authorityEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            authority = string2;
        }
        if (pathStartIndex != -1) {
            String string = data.substring(pathStartIndex, pathEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            path = string;
        }
        if (queryStartIndex != -1) {
            String string = data.substring(queryStartIndex, queryEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            query = string;
        }
        if (fragmentStartIndex != -1) {
            String string = data.substring(fragmentStartIndex, data.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fragment = string;
        }
        int maxLength = Math.max(0, Math.max(UriKt.getLength(scheme), Math.max(UriKt.getLength(authority), Math.max(UriKt.getLength(path), Math.max(UriKt.getLength(query), UriKt.getLength(fragment))))) - 2);
        byte[] bytes = new byte[maxLength];
        String string = scheme;
        String string3 = authority;
        String string4 = path;
        String string5 = query;
        String string6 = fragment;
        return new Uri(data, separator, string != null ? UriKt.percentDecode(string, bytes) : null, string3 != null ? UriKt.percentDecode(string3, bytes) : null, string4 != null ? UriKt.percentDecode(string4, bytes) : null, string5 != null ? UriKt.percentDecode(string5, bytes) : null, string6 != null ? UriKt.percentDecode(string6, bytes) : null);
    }

    private static final String percentDecode(String $this$percentDecode, byte[] bytes) {
        int size = 0;
        int index = 0;
        int length = $this$percentDecode.length();
        int searchLength = Math.max(0, length - 2);
        while (true) {
            if (index >= searchLength) {
                if (index == size) {
                    return $this$percentDecode;
                }
                if (index >= length) {
                    return StringsKt.decodeToString$default((byte[])bytes, (int)0, (int)size, (boolean)false, (int)5, null);
                }
            } else if ($this$percentDecode.charAt(index) == '%') {
                try {
                    String hex;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$percentDecode.substring(index + 1, index + 3), (String)"substring(...)");
                    bytes[size] = (byte)Integer.parseInt(hex, CharsKt.checkRadix((int)16));
                    ++size;
                    index += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            bytes[size] = (byte)$this$percentDecode.charAt(index);
            ++size;
            ++index;
        }
    }

    private static final int getLength(String $this$length) {
        String string = $this$length;
        return string != null ? string.length() : 0;
    }

    @JvmOverloads
    @NotNull
    public static final Uri toUri(@NotNull String $this$toUri) {
        return UriKt.toUri$default($this$toUri, null, 1, null);
    }
}

