/*
 * Decompiled with CFR 0.152.
 */
package coil3.memory;

import coil3.Image;
import coil3.PlatformContext;
import coil3.memory.EmptyStrongMemoryCache;
import coil3.memory.EmptyWeakMemoryCache;
import coil3.memory.RealMemoryCache;
import coil3.memory.RealStrongMemoryCache;
import coil3.memory.RealWeakMemoryCache;
import coil3.memory.StrongMemoryCache;
import coil3.memory.WeakMemoryCache;
import coil3.util.Collections_jvmCommonKt;
import coil3.util.ContextsKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019J\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u00a6\u0002J\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u00a6\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nH&J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0016\u001a\u00020\u0011H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lcoil3/memory/MemoryCache;", "", "size", "", "getSize", "()J", "maxSize", "getMaxSize", "keys", "", "Lcoil3/memory/MemoryCache$Key;", "getKeys", "()Ljava/util/Set;", "get", "Lcoil3/memory/MemoryCache$Value;", "key", "set", "", "value", "remove", "", "trimToSize", "clear", "Key", "Value", "Builder", "coil-core"})
public interface MemoryCache {
    public long getSize();

    public long getMaxSize();

    @NotNull
    public Set<Key> getKeys();

    @Nullable
    public Value get(@NotNull Key var1);

    public void set(@NotNull Key var1, @NotNull Value var2);

    public boolean remove(@NotNull Key var1);

    public void trimToSize(long var1);

    public void clear();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil3/memory/MemoryCache$Builder;", "", "<init>", "()V", "maxSizeBytesFactory", "Lkotlin/Function0;", "", "strongReferencesEnabled", "", "weakReferencesEnabled", "maxSizeBytes", "size", "maxSizePercent", "context", "Lcoil3/PlatformContext;", "percent", "", "enable", "build", "Lcoil3/memory/MemoryCache;", "coil-core"})
    @SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncoil3/memory/MemoryCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
    public static final class Builder {
        @Nullable
        private Function0<Long> maxSizeBytesFactory;
        private boolean strongReferencesEnabled = true;
        private boolean weakReferencesEnabled = true;

        @NotNull
        public final Builder maxSizeBytes(long size) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$maxSizeBytes_u24lambda_u241.maxSizeBytesFactory = () -> Builder.maxSizeBytes$lambda$1$lambda$0(size);
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(@NotNull Function0<Long> size) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$maxSizeBytes_u24lambda_u242.maxSizeBytesFactory = size;
            return builder;
        }

        @NotNull
        public final Builder maxSizePercent(@NotNull PlatformContext context, double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u245 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "percent must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u245.maxSizeBytesFactory = () -> Builder.maxSizePercent$lambda$5$lambda$4(percent, context);
            return builder;
        }

        public static /* synthetic */ Builder maxSizePercent$default(Builder builder, PlatformContext platformContext, double d, int n, Object object) {
            if ((n & 2) != 0) {
                d = ContextsKt.defaultMemoryCacheSizePercent(platformContext);
            }
            return builder.maxSizePercent(platformContext, d);
        }

        @NotNull
        public final Builder strongReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$strongReferencesEnabled_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$strongReferencesEnabled_u24lambda_u246.strongReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final Builder weakReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$weakReferencesEnabled_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$weakReferencesEnabled_u24lambda_u247.weakReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final MemoryCache build() {
            StrongMemoryCache strongMemoryCache;
            WeakMemoryCache weakMemoryCache;
            WeakMemoryCache weakMemoryCache2 = weakMemoryCache = this.weakReferencesEnabled ? (WeakMemoryCache)new RealWeakMemoryCache() : (WeakMemoryCache)new EmptyWeakMemoryCache();
            if (this.strongReferencesEnabled) {
                Function0<Long> function0 = this.maxSizeBytesFactory;
                if (function0 == null) {
                    boolean bl = false;
                    String string = "maxSizeBytesFactory == null";
                    throw new IllegalStateException(string.toString());
                }
                Function0<Long> maxSizeBytesFactory = function0;
                long maxSizeBytes = ((Number)maxSizeBytesFactory.invoke()).longValue();
                strongMemoryCache = maxSizeBytes > 0L ? (StrongMemoryCache)new RealStrongMemoryCache(maxSizeBytes, weakMemoryCache) : (StrongMemoryCache)new EmptyStrongMemoryCache(weakMemoryCache);
            } else {
                strongMemoryCache = new EmptyStrongMemoryCache(weakMemoryCache);
            }
            StrongMemoryCache strongMemoryCache2 = strongMemoryCache;
            return new RealMemoryCache(strongMemoryCache2, weakMemoryCache);
        }

        private static final long maxSizeBytes$lambda$1$lambda$0(long $size) {
            return $size;
        }

        private static final long maxSizePercent$lambda$5$lambda$4(double $percent, PlatformContext $context) {
            return (long)($percent * (double)ContextsKt.totalAvailableMemoryBytes($context));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcoil3/memory/MemoryCache$Key;", "", "key", "", "extras", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getKey", "()Ljava/lang/String;", "getExtras", "()Ljava/util/Map;", "copy", "equals", "", "other", "hashCode", "", "toString", "coil-core"})
    public static final class Key {
        @NotNull
        private final String key;
        @NotNull
        private final Map<String, String> extras;

        @JvmOverloads
        public Key(@NotNull String key, @NotNull Map<String, String> extras) {
            this.key = key;
            this.extras = Collections_jvmCommonKt.toImmutableMap(extras);
        }

        public /* synthetic */ Key(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, map);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Map<String, String> getExtras() {
            return this.extras;
        }

        @NotNull
        public final Key copy(@NotNull String key, @NotNull Map<String, String> extras) {
            return new Key(key, extras);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.key;
            }
            if ((n & 2) != 0) {
                map = key.extras;
            }
            return key.copy(string, map);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Key && Intrinsics.areEqual((Object)this.key, (Object)((Key)other).key) && Intrinsics.areEqual(this.extras, ((Key)other).extras);
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = 31 * result2 + ((Object)this.extras).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Key(key=" + this.key + ", extras=" + this.extras + ')';
        }

        @JvmOverloads
        public Key(@NotNull String key) {
            this(key, null, 2, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcoil3/memory/MemoryCache$Value;", "", "image", "Lcoil3/Image;", "extras", "", "", "<init>", "(Lcoil3/Image;Ljava/util/Map;)V", "getImage", "()Lcoil3/Image;", "getExtras", "()Ljava/util/Map;", "copy", "equals", "", "other", "hashCode", "", "toString", "coil-core"})
    public static final class Value {
        @NotNull
        private final Image image;
        @NotNull
        private final Map<String, Object> extras;

        @JvmOverloads
        public Value(@NotNull Image image, @NotNull Map<String, ? extends Object> extras) {
            this.image = image;
            this.extras = Collections_jvmCommonKt.toImmutableMap(extras);
        }

        public /* synthetic */ Value(Image image, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(image, map);
        }

        @NotNull
        public final Image getImage() {
            return this.image;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        @NotNull
        public final Value copy(@NotNull Image image, @NotNull Map<String, ? extends Object> extras) {
            return new Value(image, extras);
        }

        public static /* synthetic */ Value copy$default(Value value, Image image, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                image = value.image;
            }
            if ((n & 2) != 0) {
                map = value.extras;
            }
            return value.copy(image, map);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Value && Intrinsics.areEqual((Object)this.image, (Object)((Value)other).image) && Intrinsics.areEqual(this.extras, ((Value)other).extras);
        }

        public int hashCode() {
            int result2 = this.image.hashCode();
            result2 = 31 * result2 + ((Object)this.extras).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Value(image=" + this.image + ", extras=" + this.extras + ')';
        }

        @JvmOverloads
        public Value(@NotNull Image image) {
            this(image, null, 2, null);
        }
    }
}

