/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import coil3.util.UtilsKt;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0000\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"createFile", "", "Lokio/FileSystem;", "file", "Lokio/Path;", "mustCreate", "", "createTempFile", "deleteContents", "directory", "extension", "", "getExtension", "(Lokio/Path;)Ljava/lang/String;", "coil-core"})
public final class FileSystemsKt {
    public static final void createFile(@NotNull FileSystem $this$createFile, @NotNull Path file, boolean mustCreate) {
        if (mustCreate) {
            UtilsKt.closeQuietly((Closeable)$this$createFile.sink(file, true));
        } else if (!$this$createFile.exists(file)) {
            UtilsKt.closeQuietly((Closeable)$this$createFile.sink(file));
        }
    }

    public static /* synthetic */ void createFile$default(FileSystem fileSystem2, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        FileSystemsKt.createFile(fileSystem2, path, bl);
    }

    @NotNull
    public static final Path createTempFile(@NotNull FileSystem $this$createTempFile) {
        Path tempFile = null;
        while ($this$createTempFile.exists(tempFile = FileSystem.SYSTEM_TEMPORARY_DIRECTORY.resolve("tmp_" + ULong.toString-impl((long)URandomKt.nextULong((Random)((Random)Random.Default)))))) {
        }
        FileSystemsKt.createFile($this$createTempFile, tempFile, true);
        return tempFile;
    }

    public static final void deleteContents(@NotNull FileSystem $this$deleteContents, @NotNull Path directory) {
        List list;
        IOException exception = null;
        try {
            list = $this$deleteContents.list(directory);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        List files = list;
        for (Path file : files) {
            try {
                if ($this$deleteContents.metadata(file).isDirectory()) {
                    FileSystemsKt.deleteContents($this$deleteContents, file);
                }
                $this$deleteContents.delete(file);
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        return StringsKt.substringAfterLast((String)$this$extension.name(), (char)'.', (String)"");
    }
}

