/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.certificates.v1;

import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.CertificateSigningRequestResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CertificateSigningRequestOperationsImpl
extends HasMetadataOperation<CertificateSigningRequest, CertificateSigningRequestList, CertificateSigningRequestResource<CertificateSigningRequest>>
implements CertificateSigningRequestResource<CertificateSigningRequest> {
    public CertificateSigningRequestOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public CertificateSigningRequestOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public CertificateSigningRequestOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("certificates.k8s.io").withApiGroupVersion("v1").withCascading(true).withPlural("certificatesigningrequests"), CertificateSigningRequest.class, CertificateSigningRequestList.class);
    }

    public CertificateSigningRequestOperationsImpl newInstance(OperationContext context) {
        return new CertificateSigningRequestOperationsImpl(context);
    }

    @Override
    public CertificateSigningRequest approve(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.approveOrDeny(certificateSigningRequestCondition);
    }

    @Override
    public CertificateSigningRequest deny(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.approveOrDeny(certificateSigningRequestCondition);
    }

    private CertificateSigningRequest approveOrDeny(CertificateSigningRequestCondition csrCondition) {
        try {
            CertificateSigningRequest fromServerCsr = (CertificateSigningRequest)this.fromServer().get();
            fromServerCsr.setStatus(this.createCertificateSigningRequestStatus(csrCondition));
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)fromServerCsr));
            URL url = new URL(URLUtils.join(this.getResourceUrl(null, fromServerCsr.getMetadata().getName(), false).toString(), "approval"));
            Request.Builder requestBuilder = new Request.Builder().put(body).url(url);
            return this.handleResponse(requestBuilder, CertificateSigningRequest.class);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("CeritificateSigningRequest " + this.type), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("CertificateSigningRequest " + this.type), (Throwable)e);
        }
    }

    private CertificateSigningRequestStatus createCertificateSigningRequestStatus(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return ((CertificateSigningRequestStatusBuilder)new CertificateSigningRequestStatusBuilder().addToConditions(new CertificateSigningRequestCondition[]{certificateSigningRequestCondition})).build();
    }
}

