package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIServiceConditionBuilder extends io.fabric8.kubernetes.api.model.APIServiceConditionFluentImpl<io.fabric8.kubernetes.api.model.APIServiceConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIServiceCondition,io.fabric8.kubernetes.api.model.APIServiceConditionBuilder>{
  public APIServiceConditionBuilder() {
    this(false);
  }
  public APIServiceConditionBuilder(java.lang.Boolean validationEnabled) {
    this(new APIServiceCondition(), validationEnabled);
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServiceCondition(), validationEnabled);
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceCondition instance) {
    this(fluent, instance, false);
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceCondition instance) {
    this(instance,false);
  }
  public APIServiceConditionBuilder(io.fabric8.kubernetes.api.model.APIServiceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIServiceConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIServiceCondition build() {
    APIServiceCondition buildable = new APIServiceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServiceConditionBuilder that = (APIServiceConditionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}