package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ContainerStateBuilder extends io.fabric8.kubernetes.api.model.ContainerStateFluentImpl<io.fabric8.kubernetes.api.model.ContainerStateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerState,io.fabric8.kubernetes.api.model.ContainerStateBuilder>{
  public ContainerStateBuilder() {
    this(false);
  }
  public ContainerStateBuilder(java.lang.Boolean validationEnabled) {
    this(new ContainerState(), validationEnabled);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerState(), validationEnabled);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerState instance) {
    this(fluent, instance, false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerState instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRunning(instance.getRunning()); 
    fluent.withTerminated(instance.getTerminated()); 
    fluent.withWaiting(instance.getWaiting()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerState instance) {
    this(instance,false);
  }
  public ContainerStateBuilder(io.fabric8.kubernetes.api.model.ContainerState instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRunning(instance.getRunning()); 
    this.withTerminated(instance.getTerminated()); 
    this.withWaiting(instance.getWaiting()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerState build() {
    ContainerState buildable = new ContainerState(fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStateBuilder that = (ContainerStateBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}