package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NamedExtensionBuilder extends io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl<io.fabric8.kubernetes.api.model.NamedExtensionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NamedExtension,io.fabric8.kubernetes.api.model.NamedExtensionBuilder>{
  public NamedExtensionBuilder() {
    this(false);
  }
  public NamedExtensionBuilder(java.lang.Boolean validationEnabled) {
    this(new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedExtension instance) {
    this(fluent, instance, false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedExtension instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExtension(instance.getExtension()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtension instance) {
    this(instance,false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtension instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExtension(instance.getExtension()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedExtension build() {
    NamedExtension buildable = new NamedExtension(fluent.getExtension(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedExtensionBuilder that = (NamedExtensionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}