package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public class NodeStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.NodeStatusFluent<A>{
  public NodeStatusFluentImpl() {
  }
  public NodeStatusFluentImpl(io.fabric8.kubernetes.api.model.NodeStatus instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withAllocatable(instance.getAllocatable()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withConfig(instance.getConfig()); 
    this.withDaemonEndpoints(instance.getDaemonEndpoints()); 
    this.withImages(instance.getImages()); 
    this.withNodeInfo(instance.getNodeInfo()); 
    this.withPhase(instance.getPhase()); 
    this.withVolumesAttached(instance.getVolumesAttached()); 
    this.withVolumesInUse(instance.getVolumesInUse()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.NodeAddressBuilder> addresses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddressBuilder>();
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> allocatable;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity;
  private java.util.List<io.fabric8.kubernetes.api.model.NodeConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeConditionBuilder>();
  private io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder config;
  private io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder daemonEndpoints;
  private java.util.List<io.fabric8.kubernetes.api.model.ContainerImageBuilder> images =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerImageBuilder>();
  private io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder nodeInfo;
  private java.lang.String phase;
  private java.util.List<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> volumesAttached =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>();
  private java.util.List<java.lang.String> volumesInUse = new java.util.ArrayList<java.lang.String>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddressBuilder>();}
    io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddressBuilder>();}
    io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.NodeAddress> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.NodeAddress> items) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NodeAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NodeAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> getAddresses() {
    return build(addresses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> buildAddresses() {
    return build(addresses);
  }
  public io.fabric8.kubernetes.api.model.NodeAddress buildAddress(java.lang.Integer index) {
    return this.addresses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NodeAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NodeAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NodeAddress buildMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NodeAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (io.fabric8.kubernetes.api.model.NodeAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(java.lang.String address,java.lang.String type) {
    return (A)addToAddresses(new NodeAddress(address, type));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> addNewAddress() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.AddressesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> addNewAddressLike(io.fabric8.kubernetes.api.model.NodeAddress item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.AddressesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> setNewAddressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.AddressesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editAddress(java.lang.Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public A addToAllocatable(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.allocatable == null && key != null && value != null) { this.allocatable = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
  }
  public A addToAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatable == null && map != null) { this.allocatable = new java.util.LinkedHashMap(); }
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
  }
  public A removeFromAllocatable(java.lang.String key) {
    if(this.allocatable == null) { return (A) this; }
    if(key != null && this.allocatable != null) {this.allocatable.remove(key);} return (A)this;
  }
  public A removeFromAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatable == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatable != null){this.allocatable.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getAllocatable() {
    return this.allocatable;
  }
  public <K,V>A withAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> allocatable) {
    if (allocatable == null) { this.allocatable =  null;} else {this.allocatable = new java.util.LinkedHashMap(allocatable);} return (A) this;
  }
  public java.lang.Boolean hasAllocatable() {
    return this.allocatable != null;
  }
  public A addToCapacity(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(java.lang.String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new java.util.LinkedHashMap(capacity);} return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeConditionBuilder>();}
    io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeConditionBuilder>();}
    io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.NodeCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NodeCondition item : items) {io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NodeCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NodeCondition item : items) {io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NodeCondition... items) {
    for (io.fabric8.kubernetes.api.model.NodeCondition item : items) {io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NodeCondition> items) {
    for (io.fabric8.kubernetes.api.model.NodeCondition item : items) {io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NodeConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NodeConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.NodeCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NodeCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.NodeCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NodeCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NodeCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NodeCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.NodeCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NodeCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.NodeCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.NodeCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.NodeCondition item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeCondition item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NodeConfigStatus getConfig() {
    return this.config!=null?this.config.build():null;
  }
  public io.fabric8.kubernetes.api.model.NodeConfigStatus buildConfig() {
    return this.config!=null?this.config.build():null;
  }
  public A withConfig(io.fabric8.kubernetes.api.model.NodeConfigStatus config) {
    _visitables.get("config").remove(this.config);
    if (config!=null){ this.config= new io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
  }
  public java.lang.Boolean hasConfig() {
    return this.config != null;
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> withNewConfig() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ConfigNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> withNewConfigLike(io.fabric8.kubernetes.api.model.NodeConfigStatus item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ConfigNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editConfig() {
    return withNewConfigLike(getConfig());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(getConfig() != null ? getConfig(): new io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(io.fabric8.kubernetes.api.model.NodeConfigStatus item) {
    return withNewConfigLike(getConfig() != null ? getConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDaemonEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NodeDaemonEndpoints getDaemonEndpoints() {
    return this.daemonEndpoints!=null?this.daemonEndpoints.build():null;
  }
  public io.fabric8.kubernetes.api.model.NodeDaemonEndpoints buildDaemonEndpoints() {
    return this.daemonEndpoints!=null?this.daemonEndpoints.build():null;
  }
  public A withDaemonEndpoints(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints daemonEndpoints) {
    _visitables.get("daemonEndpoints").remove(this.daemonEndpoints);
    if (daemonEndpoints!=null){ this.daemonEndpoints= new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder(daemonEndpoints); _visitables.get("daemonEndpoints").add(this.daemonEndpoints);} return (A) this;
  }
  public java.lang.Boolean hasDaemonEndpoints() {
    return this.daemonEndpoints != null;
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.DaemonEndpointsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.DaemonEndpointsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints() {
    return withNewDaemonEndpointsLike(getDaemonEndpoints());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
    return withNewDaemonEndpointsLike(getDaemonEndpoints() != null ? getDaemonEndpoints(): new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints item) {
    return withNewDaemonEndpointsLike(getDaemonEndpoints() != null ? getDaemonEndpoints(): item);
  }
  public A addToImages(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerImage item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerImageBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerImage item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerImageBuilder>();}
    io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.kubernetes.api.model.ContainerImage... items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerImageBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerImage item : items) {io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerImage> items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ContainerImageBuilder>();}
    for (io.fabric8.kubernetes.api.model.ContainerImage item : items) {io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.kubernetes.api.model.ContainerImage... items) {
    for (io.fabric8.kubernetes.api.model.ContainerImage item : items) {io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerImage> items) {
    for (io.fabric8.kubernetes.api.model.ContainerImage item : items) {io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerImageBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ContainerImageBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ContainerImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerImage> getImages() {
    return build(images);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ContainerImage> buildImages() {
    return build(images);
  }
  public io.fabric8.kubernetes.api.model.ContainerImage buildImage(java.lang.Integer index) {
    return this.images.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerImage buildFirstImage() {
    return this.images.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerImage buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ContainerImage buildMatchingImage(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerImageBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerImageBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingImage(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerImageBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ContainerImageBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(java.util.List<io.fabric8.kubernetes.api.model.ContainerImage> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ContainerImage item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.kubernetes.api.model.ContainerImage... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (io.fabric8.kubernetes.api.model.ContainerImage item :images){ this.addToImages(item);}} return (A) this;
  }
  public java.lang.Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> addNewImage() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ImagesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> addNewImageLike(io.fabric8.kubernetes.api.model.ContainerImage item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ImagesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> setNewImageLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerImage item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.ImagesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editImage(java.lang.Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editMatchingImage(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  /**
   * This method has been deprecated, please use method buildNodeInfo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NodeSystemInfo getNodeInfo() {
    return this.nodeInfo!=null?this.nodeInfo.build():null;
  }
  public io.fabric8.kubernetes.api.model.NodeSystemInfo buildNodeInfo() {
    return this.nodeInfo!=null?this.nodeInfo.build():null;
  }
  public A withNodeInfo(io.fabric8.kubernetes.api.model.NodeSystemInfo nodeInfo) {
    _visitables.get("nodeInfo").remove(this.nodeInfo);
    if (nodeInfo!=null){ this.nodeInfo= new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder(nodeInfo); _visitables.get("nodeInfo").add(this.nodeInfo);} return (A) this;
  }
  public java.lang.Boolean hasNodeInfo() {
    return this.nodeInfo != null;
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.NodeInfoNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(io.fabric8.kubernetes.api.model.NodeSystemInfo item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.NodeInfoNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editNodeInfo() {
    return withNewNodeInfoLike(getNodeInfo());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo() {
    return withNewNodeInfoLike(getNodeInfo() != null ? getNodeInfo(): new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(io.fabric8.kubernetes.api.model.NodeSystemInfo item) {
    return withNewNodeInfoLike(getNodeInfo() != null ? getNodeInfo(): item);
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  
  /**
   * Method is deprecated. use withPhase instead.
   */
  @java.lang.Deprecated
  public A withNewPhase(java.lang.String arg0) {
    return (A)withPhase(new String(arg0));
  }
  public A addToVolumesAttached(java.lang.Integer index,io.fabric8.kubernetes.api.model.AttachedVolume item) {
    if (this.volumesAttached == null) {this.volumesAttached = new java.util.ArrayList<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>();}
    io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);_visitables.get("volumesAttached").add(index >= 0 ? index : _visitables.get("volumesAttached").size(), builder);this.volumesAttached.add(index >= 0 ? index : volumesAttached.size(), builder); return (A)this;
  }
  public A setToVolumesAttached(java.lang.Integer index,io.fabric8.kubernetes.api.model.AttachedVolume item) {
    if (this.volumesAttached == null) {this.volumesAttached = new java.util.ArrayList<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>();}
    io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumesAttached").size()) { _visitables.get("volumesAttached").add(builder); } else { _visitables.get("volumesAttached").set(index, builder);}
    if (index < 0 || index >= volumesAttached.size()) { volumesAttached.add(builder); } else { volumesAttached.set(index, builder);}
     return (A)this;
  }
  public A addToVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items) {
    if (this.volumesAttached == null) {this.volumesAttached = new java.util.ArrayList<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.AttachedVolume item : items) {io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);_visitables.get("volumesAttached").add(builder);this.volumesAttached.add(builder);} return (A)this;
  }
  public A addAllToVolumesAttached(java.util.Collection<io.fabric8.kubernetes.api.model.AttachedVolume> items) {
    if (this.volumesAttached == null) {this.volumesAttached = new java.util.ArrayList<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder>();}
    for (io.fabric8.kubernetes.api.model.AttachedVolume item : items) {io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);_visitables.get("volumesAttached").add(builder);this.volumesAttached.add(builder);} return (A)this;
  }
  public A removeFromVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items) {
    for (io.fabric8.kubernetes.api.model.AttachedVolume item : items) {io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);_visitables.get("volumesAttached").remove(builder);if (this.volumesAttached != null) {this.volumesAttached.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumesAttached(java.util.Collection<io.fabric8.kubernetes.api.model.AttachedVolume> items) {
    for (io.fabric8.kubernetes.api.model.AttachedVolume item : items) {io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(item);_visitables.get("volumesAttached").remove(builder);if (this.volumesAttached != null) {this.volumesAttached.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumesAttached(java.util.function.Predicate<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> predicate) {
    if (volumesAttached == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> each = volumesAttached.iterator();
    final List visitables = _visitables.get("volumesAttached");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumesAttached instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.AttachedVolume> getVolumesAttached() {
    return build(volumesAttached);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.AttachedVolume> buildVolumesAttached() {
    return build(volumesAttached);
  }
  public io.fabric8.kubernetes.api.model.AttachedVolume buildVolumesAttached(java.lang.Integer index) {
    return this.volumesAttached.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.AttachedVolume buildFirstVolumesAttached() {
    return this.volumesAttached.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.AttachedVolume buildLastVolumesAttached() {
    return this.volumesAttached.get(volumesAttached.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.AttachedVolume buildMatchingVolumesAttached(java.util.function.Predicate<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.AttachedVolumeBuilder item: volumesAttached) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolumesAttached(java.util.function.Predicate<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.AttachedVolumeBuilder item: volumesAttached) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumesAttached(java.util.List<io.fabric8.kubernetes.api.model.AttachedVolume> volumesAttached) {
    if (this.volumesAttached != null) { _visitables.get("volumesAttached").removeAll(this.volumesAttached);}
    if (volumesAttached != null) {this.volumesAttached = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.AttachedVolume item : volumesAttached){this.addToVolumesAttached(item);}} else { this.volumesAttached = null;} return (A) this;
  }
  public A withVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... volumesAttached) {
    if (this.volumesAttached != null) {this.volumesAttached.clear();}
    if (volumesAttached != null) {for (io.fabric8.kubernetes.api.model.AttachedVolume item :volumesAttached){ this.addToVolumesAttached(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumesAttached() {
    return volumesAttached != null && !volumesAttached.isEmpty();
  }
  public A addNewVolumesAttached(java.lang.String devicePath,java.lang.String name) {
    return (A)addToVolumesAttached(new AttachedVolume(devicePath, name));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached() {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.VolumesAttachedNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(io.fabric8.kubernetes.api.model.AttachedVolume item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.VolumesAttachedNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.AttachedVolume item) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentImpl.VolumesAttachedNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(java.lang.Integer index) {
    if (volumesAttached.size() <= index) throw new RuntimeException("Can't edit volumesAttached. Index exceeds size.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached() {
    if (volumesAttached.size() == 0) throw new RuntimeException("Can't edit first volumesAttached. The list is empty.");
    return setNewVolumesAttachedLike(0, buildVolumesAttached(0));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached() {
    int index = volumesAttached.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumesAttached. The list is empty.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(java.util.function.Predicate<io.fabric8.kubernetes.api.model.AttachedVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumesAttached.size();i++) { 
    if (predicate.test(volumesAttached.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumesAttached. No match found.");
    return setNewVolumesAttachedLike(index, buildVolumesAttached(index));
  }
  public A addToVolumesInUse(java.lang.Integer index,java.lang.String item) {
    if (this.volumesInUse == null) {this.volumesInUse = new java.util.ArrayList<java.lang.String>();}
    this.volumesInUse.add(index, item);
    return (A)this;
  }
  public A setToVolumesInUse(java.lang.Integer index,java.lang.String item) {
    if (this.volumesInUse == null) {this.volumesInUse = new java.util.ArrayList<java.lang.String>();}
    this.volumesInUse.set(index, item); return (A)this;
  }
  public A addToVolumesInUse(java.lang.String... items) {
    if (this.volumesInUse == null) {this.volumesInUse = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.volumesInUse.add(item);} return (A)this;
  }
  public A addAllToVolumesInUse(java.util.Collection<java.lang.String> items) {
    if (this.volumesInUse == null) {this.volumesInUse = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.volumesInUse.add(item);} return (A)this;
  }
  public A removeFromVolumesInUse(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.volumesInUse!= null){ this.volumesInUse.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumesInUse(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.volumesInUse!= null){ this.volumesInUse.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getVolumesInUse() {
    return this.volumesInUse;
  }
  public java.lang.String getVolumesInUse(java.lang.Integer index) {
    return this.volumesInUse.get(index);
  }
  public java.lang.String getFirstVolumesInUse() {
    return this.volumesInUse.get(0);
  }
  public java.lang.String getLastVolumesInUse() {
    return this.volumesInUse.get(volumesInUse.size() - 1);
  }
  public java.lang.String getMatchingVolumesInUse(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: volumesInUse) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVolumesInUse(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: volumesInUse) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumesInUse(java.util.List<java.lang.String> volumesInUse) {
    if (volumesInUse != null) {this.volumesInUse = new java.util.ArrayList(); for (java.lang.String item : volumesInUse){this.addToVolumesInUse(item);}} else { this.volumesInUse = null;} return (A) this;
  }
  public A withVolumesInUse(java.lang.String... volumesInUse) {
    if (this.volumesInUse != null) {this.volumesInUse.clear();}
    if (volumesInUse != null) {for (java.lang.String item :volumesInUse){ this.addToVolumesInUse(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumesInUse() {
    return volumesInUse != null && !volumesInUse.isEmpty();
  }
  public A addNewVolumesInUse(java.lang.String arg0) {
    return (A)addToVolumesInUse(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (config != null ? !config.equals(that.config) :that.config != null) return false;
    if (daemonEndpoints != null ? !daemonEndpoints.equals(that.daemonEndpoints) :that.daemonEndpoints != null) return false;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (nodeInfo != null ? !nodeInfo.equals(that.nodeInfo) :that.nodeInfo != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (volumesAttached != null ? !volumesAttached.equals(that.volumesAttached) :that.volumesAttached != null) return false;
    if (volumesInUse != null ? !volumesInUse.equals(that.volumesInUse) :that.volumesInUse != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  allocatable,  capacity,  conditions,  config,  daemonEndpoints,  images,  nodeInfo,  phase,  volumesAttached,  volumesInUse,  additionalProperties,  super.hashCode());
  }
  public class AddressesNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeAddressFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AddressesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NodeAddressBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeAddressBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NodeStatusFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeConditionFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NodeConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NodeStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ConfigNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeConfigStatusFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigNestedImpl(io.fabric8.kubernetes.api.model.NodeConfigStatus item) {
      this.builder = new io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder(this, item);
    }
    ConfigNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder builder;
    public N and() {
      return (N) NodeStatusFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig() {
      return and();
    }
    
  }
  public class DaemonEndpointsNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DaemonEndpointsNestedImpl(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints item) {
      this.builder = new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder(this, item);
    }
    DaemonEndpointsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder builder;
    public N and() {
      return (N) NodeStatusFluentImpl.this.withDaemonEndpoints(builder.build());
    }
    public N endDaemonEndpoints() {
      return and();
    }
    
  }
  public class ImagesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ContainerImageFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImagesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ContainerImage item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ContainerImageBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ContainerImageBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NodeStatusFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  public class NodeInfoNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeSystemInfoFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeInfoNestedImpl(io.fabric8.kubernetes.api.model.NodeSystemInfo item) {
      this.builder = new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder(this, item);
    }
    NodeInfoNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder builder;
    public N and() {
      return (N) NodeStatusFluentImpl.this.withNodeInfo(builder.build());
    }
    public N endNodeInfo() {
      return and();
    }
    
  }
  public class VolumesAttachedNestedImpl<N> extends io.fabric8.kubernetes.api.model.AttachedVolumeFluentImpl<io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<N>> implements io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumesAttachedNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.AttachedVolume item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(this, item);
    }
    VolumesAttachedNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.AttachedVolumeBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AttachedVolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NodeStatusFluentImpl.this.setToVolumesAttached(index,builder.build());
    }
    public N endVolumesAttached() {
      return and();
    }
    
  }
  
}