package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ProbeBuilder extends io.fabric8.kubernetes.api.model.ProbeFluentImpl<io.fabric8.kubernetes.api.model.ProbeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Probe,io.fabric8.kubernetes.api.model.ProbeBuilder>{
  public ProbeBuilder() {
    this(false);
  }
  public ProbeBuilder(java.lang.Boolean validationEnabled) {
    this(new Probe(), validationEnabled);
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.ProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.ProbeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Probe(), validationEnabled);
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.ProbeFluent<?> fluent,io.fabric8.kubernetes.api.model.Probe instance) {
    this(fluent, instance, false);
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.ProbeFluent<?> fluent,io.fabric8.kubernetes.api.model.Probe instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExec(instance.getExec()); 
    fluent.withFailureThreshold(instance.getFailureThreshold()); 
    fluent.withGrpc(instance.getGrpc()); 
    fluent.withHttpGet(instance.getHttpGet()); 
    fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    fluent.withPeriodSeconds(instance.getPeriodSeconds()); 
    fluent.withSuccessThreshold(instance.getSuccessThreshold()); 
    fluent.withTcpSocket(instance.getTcpSocket()); 
    fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.Probe instance) {
    this(instance,false);
  }
  public ProbeBuilder(io.fabric8.kubernetes.api.model.Probe instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExec(instance.getExec()); 
    this.withFailureThreshold(instance.getFailureThreshold()); 
    this.withGrpc(instance.getGrpc()); 
    this.withHttpGet(instance.getHttpGet()); 
    this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    this.withPeriodSeconds(instance.getPeriodSeconds()); 
    this.withSuccessThreshold(instance.getSuccessThreshold()); 
    this.withTcpSocket(instance.getTcpSocket()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ProbeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Probe build() {
    Probe buildable = new Probe(fluent.getExec(),fluent.getFailureThreshold(),fluent.getGrpc(),fluent.getHttpGet(),fluent.getInitialDelaySeconds(),fluent.getPeriodSeconds(),fluent.getSuccessThreshold(),fluent.getTcpSocket(),fluent.getTerminationGracePeriodSeconds(),fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeBuilder that = (ProbeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}