/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.async.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class AsyncBeanProperties {
    public static final String PREFIX = "spring-startup-analyzer.boost.spring.async";
    private boolean beanPriorityLoadEnable = false;
    private static final String asyncBeanPriorityLoadEnableKey = String.format("%s.bean-priority-load-enable", "spring-startup-analyzer.boost.spring.async");
    private List<String> beanNames = new ArrayList<String>();
    private static final String beanNamesKey = String.format("%s.bean-names", "spring-startup-analyzer.boost.spring.async");
    private final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private int initBeanThreadPoolCoreSize = this.CPU_COUNT + 1;
    private static final String initBeanThreadPoolCoreSizeKey = String.format("%s.init-bean-thread-pool-core-size", "spring-startup-analyzer.boost.spring.async");
    private int initBeanThreadPoolMaxSize = this.CPU_COUNT + 1;
    private static final String initBeanThreadPoolMaxSizeKey = String.format("%s.init-bean-thread-pool-max-size", "spring-startup-analyzer.boost.spring.async");

    public boolean isBeanPriorityLoadEnable() {
        return this.beanPriorityLoadEnable;
    }

    public void setBeanPriorityLoadEnable(boolean beanPriorityLoadEnable) {
        this.beanPriorityLoadEnable = beanPriorityLoadEnable;
    }

    public List<String> getBeanNames() {
        return this.beanNames;
    }

    public void setBeanNames(List<String> beanNames) {
        this.beanNames = beanNames;
    }

    public int getInitBeanThreadPoolCoreSize() {
        return this.initBeanThreadPoolCoreSize;
    }

    public void setInitBeanThreadPoolCoreSize(int initBeanThreadPoolCoreSize) {
        this.initBeanThreadPoolCoreSize = initBeanThreadPoolCoreSize;
    }

    public int getInitBeanThreadPoolMaxSize() {
        return this.initBeanThreadPoolMaxSize;
    }

    public void setInitBeanThreadPoolMaxSize(int initBeanThreadPoolMaxSize) {
        this.initBeanThreadPoolMaxSize = initBeanThreadPoolMaxSize;
    }

    public static AsyncBeanProperties parse(Environment environment) {
        String maxSizeStr;
        String coreSizeStr;
        String beanNamesStr;
        AsyncBeanProperties properties = new AsyncBeanProperties();
        String enableStr = environment.getProperty(asyncBeanPriorityLoadEnableKey);
        if (!StringUtils.isEmpty((Object)enableStr)) {
            properties.setBeanPriorityLoadEnable(Boolean.parseBoolean(environment.getProperty(asyncBeanPriorityLoadEnableKey)));
        }
        if (!StringUtils.isEmpty((Object)(beanNamesStr = environment.getProperty(beanNamesKey, "").trim()))) {
            ArrayList<String> beanNameList = new ArrayList<String>();
            for (String beanName : beanNamesStr.split(",")) {
                if (StringUtils.isEmpty((Object)(beanName = beanName.trim()))) continue;
                beanNameList.add(beanName);
            }
            properties.setBeanNames(beanNameList);
        }
        if (!StringUtils.isEmpty((Object)(coreSizeStr = environment.getProperty(initBeanThreadPoolCoreSizeKey)))) {
            properties.setInitBeanThreadPoolCoreSize(Integer.parseInt(coreSizeStr));
        }
        if (!StringUtils.isEmpty((Object)(maxSizeStr = environment.getProperty(initBeanThreadPoolMaxSizeKey)))) {
            properties.setInitBeanThreadPoolMaxSize(Integer.parseInt(maxSizeStr));
        }
        return properties;
    }
}

