/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.async.executor;

import io.github.linyimin0812.async.config.AsyncConfig;
import io.github.linyimin0812.async.executor.NamedThreadFactory;
import io.github.linyimin0812.profiler.common.logger.LogFactory;
import io.github.linyimin0812.profiler.common.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncTaskExecutor {
    private static final Logger logger = LogFactory.getStartupLogger();
    private static ThreadPoolExecutor threadPool;
    private static boolean finished;
    private static final List<Future<?>> futureList;

    public static void submitTask(Runnable runnable) {
        if (threadPool == null) {
            threadPool = AsyncTaskExecutor.createThreadPoolExecutor();
        }
        futureList.add(threadPool.submit(runnable));
    }

    public static void ensureAsyncTasksFinish() {
        if (futureList.isEmpty()) {
            return;
        }
        for (Future<?> future : futureList) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        finished = true;
        futureList.clear();
        threadPool.shutdown();
    }

    public static boolean isFinished() {
        return finished;
    }

    private static ThreadPoolExecutor createThreadPoolExecutor() {
        int threadPoolCoreSize = AsyncConfig.getInstance().getAsyncBeanProperties().getInitBeanThreadPoolCoreSize();
        int threadPollMaxSize = AsyncConfig.getInstance().getAsyncBeanProperties().getInitBeanThreadPoolMaxSize();
        logger.info(AsyncTaskExecutor.class, "create async-init-bean thread pool, corePoolSize: {}, maxPoolSize: {}.", new Object[]{threadPoolCoreSize, threadPoolCoreSize});
        NamedThreadFactory threadFactory = new NamedThreadFactory("async-init-bean");
        return new ThreadPoolExecutor(threadPoolCoreSize, threadPollMaxSize, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    static {
        finished = false;
        futureList = new ArrayList();
    }
}

