/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.logger;

import io.github.linyimin0812.profiler.common.logger.Logger;
import io.github.linyimin0812.profiler.common.logger.LoggerName;
import io.github.linyimin0812.profiler.common.utils.AgentHomeUtil;
import java.util.HashMap;
import java.util.Map;

public class LogFactory {
    private static final Map<LoggerName, Logger> LOGGER_MAP = new HashMap<LoggerName, Logger>();

    public static Logger getStartupLogger() {
        return LOGGER_MAP.get((Object)LoggerName.startup);
    }

    public static Logger getTransFormLogger() {
        return LOGGER_MAP.get((Object)LoggerName.transform);
    }

    public static void close() {
        for (Logger logger : LOGGER_MAP.values()) {
            logger.close();
        }
    }

    public static void createLogger(LoggerName loggerName, String path) {
        Logger logger = new Logger(loggerName, path);
        LOGGER_MAP.put(loggerName, logger);
    }

    private static void createLogger(LoggerName loggerName) {
        LogFactory.createLogger(loggerName, AgentHomeUtil.home() + "logs");
    }

    static {
        LogFactory.createLogger(LoggerName.startup);
        LogFactory.createLogger(LoggerName.transform);
    }
}

