/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.logger;

import io.github.linyimin0812.profiler.common.logger.Level;
import io.github.linyimin0812.profiler.common.logger.LoggerName;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Logger {
    private final PrintWriter LOGGER_WRITER;

    public Logger(LoggerName loggerName, String path) {
        String file = path + File.separator + loggerName.name() + ".log";
        try {
            Path filePath = Paths.get(file, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.createFile(filePath, new FileAttribute[0]);
            }
            FileWriter fileWriter = new FileWriter(file, true);
            this.LOGGER_WRITER = new PrintWriter(fileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void debug(Class<?> clazz, String format, Object ... arguments) {
        String baseFormat = this.basFormat(Level.DEBUG, clazz);
        format = format.replace("{}", "%s");
        String message = String.format(format, arguments);
        this.write(baseFormat + message);
    }

    public void debug(Class<?> clazz, String message) {
        String baseFormat = this.basFormat(Level.DEBUG, clazz);
        this.write(baseFormat + message);
    }

    public void warn(Class<?> clazz, String format, Object ... arguments) {
        String baseFormat = this.basFormat(Level.WARN, clazz);
        format = format.replace("{}", "%s");
        String message = String.format(format, arguments);
        this.write(baseFormat + message);
    }

    public void warn(Class<?> clazz, String message) {
        String baseFormat = this.basFormat(Level.WARN, clazz);
        this.write(baseFormat + message);
    }

    public void info(Class<?> clazz, String format, Object ... arguments) {
        String baseFormat = this.basFormat(Level.INFO, clazz);
        format = format.replace("{}", "%s");
        String message = String.format(format, arguments);
        this.write(baseFormat + message);
    }

    public void info(Class<?> clazz, String message) {
        String baseFormat = this.basFormat(Level.INFO, clazz);
        this.write(baseFormat + message);
    }

    public void error(Class<?> clazz, String format, Object ... arguments) {
        String baseFormat = this.basFormat(Level.ERROR, clazz);
        format = format.replace("{}", "%s");
        String message = String.format(format, arguments);
        this.write(baseFormat + message);
    }

    public void error(Class<?> clazz, String message) {
        String baseFormat = this.basFormat(Level.ERROR, clazz);
        this.write(baseFormat + message);
    }

    public void error(Class<?> clazz, Throwable throwable) {
        String baseFormat = this.basFormat(Level.ERROR, clazz);
        this.write(baseFormat + throwable.getMessage());
    }

    private String getCurrentTime() {
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        return currentTime.format(formatter);
    }

    private String basFormat(Level level, Class<?> clazz) {
        String threadName = Thread.currentThread().getName();
        return String.format("%s %s [%s] %s - ", this.getCurrentTime(), level.name(), threadName, clazz.getName());
    }

    private void write(String message) {
        this.LOGGER_WRITER.println(message);
        this.LOGGER_WRITER.flush();
    }

    public void close() {
        if (this.LOGGER_WRITER == null) {
            return;
        }
        this.LOGGER_WRITER.close();
    }
}

