/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.utils;

import io.github.linyimin0812.profiler.common.utils.AgentHomeUtil;
import io.github.linyimin0812.profiler.common.utils.IpUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NameUtil {
    private static String appName;
    private static String startupInstanceName;

    private static void resolveAppName() {
        String separator;
        appName = System.getProperty("project.name");
        if (appName != null && !appName.isEmpty()) {
            return;
        }
        appName = System.getProperty("spring.application.name");
        if (appName != null && !appName.isEmpty()) {
            return;
        }
        String command = System.getProperty("sun.java.command");
        if (command == null || command.isEmpty()) {
            return;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
            command = strs[strs.length - 1];
        }
        if (command.toLowerCase().endsWith(".jar")) {
            command = command.substring(0, command.length() - 4);
        }
        appName = command;
    }

    public static String getAppName() {
        if (appName == null) {
            NameUtil.resolveAppName();
        }
        return appName;
    }

    public static String getStartupInstanceName() {
        if (startupInstanceName == null) {
            String currentTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            startupInstanceName = String.format("%s-%s-%s", NameUtil.getAppName(), currentTime, IpUtil.getIp());
        }
        return startupInstanceName;
    }

    public static String getFlameGraphHtmlName() {
        return NameUtil.getStartupInstanceName() + "-flame-graph.html";
    }

    public static String getAnalysisHtmlName() {
        return NameUtil.getStartupInstanceName() + "-analyzer.html";
    }

    public static String getOutputPath() {
        return AgentHomeUtil.home() + File.separator + "output" + File.separator;
    }

    public static String getTemplatePath() {
        return AgentHomeUtil.home() + File.separator + "template" + File.separator;
    }
}

