/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.utils;

import java.io.File;
import java.util.Locale;

public class OSUtil {
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String OPERATING_SYSTEM_ARCH = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
    static PlatformEnum platform = OPERATING_SYSTEM_NAME.startsWith("linux") ? PlatformEnum.LINUX : (OPERATING_SYSTEM_NAME.startsWith("mac") || OPERATING_SYSTEM_NAME.startsWith("darwin") ? PlatformEnum.MACOS : (OPERATING_SYSTEM_NAME.startsWith("windows") ? PlatformEnum.WINDOWS : PlatformEnum.UNKNOWN));
    static String arch = OSUtil.normalizeArch();

    private OSUtil() {
    }

    public static boolean isWindows() {
        return platform == PlatformEnum.WINDOWS;
    }

    public static boolean isLinux() {
        return platform == PlatformEnum.LINUX;
    }

    public static boolean isMac() {
        return platform == PlatformEnum.MACOS;
    }

    public static boolean isCygwinOrMinGW() {
        if (OSUtil.isWindows()) {
            return System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") || "/bin/bash".equals(System.getenv("SHELL"));
        }
        return false;
    }

    public static boolean isMuslLibc() {
        File ld_musl_x86_64_file = new File("/lib/ld-musl-x86_64.so.1");
        File ld_musl_aarch64_file = new File("/lib/ld-musl-aarch64.so.1");
        return ld_musl_x86_64_file.exists() || ld_musl_aarch64_file.exists();
    }

    public static String arch() {
        return arch;
    }

    public static String platform() {
        return platform.name();
    }

    public static boolean isArm32() {
        return "arm_32".equals(arch);
    }

    public static boolean isArm64() {
        return "aarch_64".equals(arch);
    }

    public static boolean isX86() {
        return "x86_32".equals(arch);
    }

    public static boolean isX86_64() {
        return "x86_64".equals(arch);
    }

    private static String normalizeArch() {
        String value = OSUtil.normalize(OPERATING_SYSTEM_ARCH);
        if (value.matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(value)) {
            return "itanium_32";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(mips|mips32)$")) {
            return "mips_32";
        }
        if (value.matches("^(mipsel|mips32el)$")) {
            return "mipsel_32";
        }
        if ("mips64".equals(value)) {
            return "mips_64";
        }
        if ("mips64el".equals(value)) {
            return "mipsel_64";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390_64";
        }
        return value;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static enum PlatformEnum {
        WINDOWS,
        LINUX,
        MACOS,
        UNKNOWN;

    }
}

