/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import io.github.linyimin0812.profiler.common.logger.LoggerName;
import io.github.linyimin0812.profiler.common.utils.OSUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class LogFactory {
    private static final LoggerContext SINGLETON = new LoggerContext();

    public static Logger getStartupLogger() {
        return SINGLETON.getLogger(LoggerName.startup.name());
    }

    public static Logger getTransFormLogger() {
        return SINGLETON.getLogger(LoggerName.transform.name());
    }

    private static void createLogger(String name, String pattern) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)SINGLETON);
        appender.setName(name);
        appender.setAppend(true);
        appender.setFile(LogFactory.getLogPath() + name + ".log");
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setContext((Context)SINGLETON);
        triggeringPolicy.start();
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setContext((Context)SINGLETON);
        rolling.setFileNamePattern(LogFactory.getLogPath() + name + ".%i.log");
        rolling.setParent((FileAppender)appender);
        rolling.setMaxIndex(5);
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        PatternLayoutEncoder layout = LogFactory.setPatternLayout(pattern);
        appender.setEncoder((Encoder)layout);
        appender.start();
        ch.qos.logback.classic.Logger logger = SINGLETON.getLogger(name);
        logger.detachAndStopAllAppenders();
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.INFO);
        LogFactory.addConsoleAppender(logger, pattern);
    }

    private static void addConsoleAppender(ch.qos.logback.classic.Logger logger, String pattern) {
        String profile = System.getProperty("spring-startup-analyzer.boost.profile");
        if (!"dev".equals(profile)) {
            return;
        }
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext((Context)new LoggerContext());
        consoleAppender.setLayout(LogFactory.setPatternLayout(pattern).getLayout());
        consoleAppender.start();
        logger.addAppender((Appender)consoleAppender);
    }

    private static PatternLayoutEncoder setPatternLayout(String pattern) {
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setPattern(pattern);
        layout.setContext((Context)SINGLETON);
        layout.setCharset(StandardCharsets.UTF_8);
        layout.start();
        return layout;
    }

    private static String getLogPath() {
        return OSUtil.home() + "logs" + File.separator;
    }

    static {
        LogFactory.createLogger(LoggerName.startup.name(), "%d{yyyy-MM-dd HH:mm:ss.SSS} %-5level [%thread] %class - %msg%n");
        LogFactory.createLogger(LoggerName.transform.name(), "%d{yyyy-MM-dd HH:mm:ss.SSS} %-5level [%thread] - %msg%n");
    }
}

