/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.settings;

import io.github.linyimin0812.profiler.common.logger.LogFactory;
import io.github.linyimin0812.profiler.common.utils.OSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;

public class ProfilerSettings {
    private static final Logger logger = LogFactory.getStartupLogger();
    private static final Properties properties = new Properties();

    public static String getProperty(String key, String defaultValue) {
        if (System.getProperties().contains(key)) {
            return System.getProperty(key);
        }
        if (properties.containsKey(key)) {
            return properties.getProperty(key);
        }
        return defaultValue;
    }

    public static String getProperty(String key) {
        if (System.getProperties().contains(key)) {
            return System.getProperty(key);
        }
        return properties.getProperty(key);
    }

    public static boolean contains(String key) {
        return properties.containsKey(key);
    }

    static {
        String settingFile = OSUtil.home() + "config" + File.separator + "spring-startup-analyzer.properties";
        try (FileInputStream fileInputStream = new FileInputStream(settingFile);){
            properties.load(fileInputStream);
            logger.info("loaded settings from {}", (Object)settingFile);
        }
        catch (IOException e) {
            logger.error("load settings from {} error.", (Object)settingFile, (Object)e);
        }
    }
}

