/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class BeanInitResult {
    private static final AtomicLong SEQUENCE_ID = new AtomicLong(1000L);
    private final long id = SEQUENCE_ID.incrementAndGet();
    private long parentId;
    private final String name;
    private long startMillis;
    private long endMillis;
    private long duration;
    private long actualDuration;
    private final Map<String, String> tags;
    private final List<BeanInitResult> children;

    public BeanInitResult(String name) {
        this.name = name;
        this.startMillis = System.currentTimeMillis();
        this.tags = new HashMap<String, String>();
        this.children = new ArrayList<BeanInitResult>();
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getActualDuration() {
        return this.actualDuration;
    }

    public void duration() {
        this.endMillis = System.currentTimeMillis();
        this.duration = this.endMillis - this.startMillis;
        long childrenDuration = this.children.stream().mapToLong(BeanInitResult::getActualDuration).sum();
        this.actualDuration = this.duration - childrenDuration;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public List<BeanInitResult> getChildren() {
        return this.children;
    }

    public void addChild(BeanInitResult child) {
        child.parentId = this.id;
        this.children.add(child);
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public long getEndMillis() {
        return this.endMillis;
    }

    public void setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    public void setTags(Map<String, String> tags) {
        this.tags.putAll(tags);
    }
}

