/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.utils;

import io.github.linyimin0812.profiler.common.logger.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;

public class MainClassUtil {
    private static final Logger logger = LogFactory.getStartupLogger();
    private static final Set<String> packages = new HashSet<String>();

    public static Set<String> getPackages() {
        return packages;
    }

    public static void resolveMainClassPackage(List<URL> manifestPath) {
        Set<String> manifestPackages = MainClassUtil.resolvePackageFromManifest(manifestPath);
        if (!manifestPackages.isEmpty()) {
            packages.addAll(manifestPackages);
            return;
        }
        Set<String> commandPackages = MainClassUtil.resolvePackageFromCommand();
        packages.addAll(commandPackages);
    }

    private static Set<String> resolvePackageFromManifest(List<URL> manifestPaths) {
        HashSet<String> startClassPackages = new HashSet<String>();
        for (URL url : manifestPaths) {
            try {
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    String startClass = attributes.getValue("Start-Class");
                    if (startClass == null || startClass.length() == 0 || !startClass.contains(".")) continue;
                    startClassPackages.add(startClass.substring(0, startClass.lastIndexOf(".")));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("parse {} error.", (Object)url.getPath(), (Object)e);
            }
        }
        return startClassPackages;
    }

    private static Set<String> resolvePackageFromCommand() {
        String separator;
        HashSet<String> mainClassPackages = new HashSet<String>();
        String command = System.getProperty("sun.java.command");
        if (command == null || command.isEmpty()) {
            return mainClassPackages;
        }
        if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
            return mainClassPackages;
        }
        if (command.contains(".")) {
            mainClassPackages.add(command.substring(0, command.lastIndexOf(".")));
        }
        return mainClassPackages;
    }
}

