/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.utils;

import java.io.File;
import java.util.Locale;

public class OSUtil {
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    static PlatformEnum platform = OPERATING_SYSTEM_NAME.startsWith("linux") ? PlatformEnum.LINUX : (OPERATING_SYSTEM_NAME.startsWith("mac") || OPERATING_SYSTEM_NAME.startsWith("darwin") ? PlatformEnum.MACOS : (OPERATING_SYSTEM_NAME.startsWith("windows") ? PlatformEnum.WINDOWS : PlatformEnum.UNKNOWN));

    public static String home() {
        return System.getProperty("user.home") + File.separator + "spring-startup-analyzer" + File.separator;
    }

    private OSUtil() {
    }

    public static boolean isWindows() {
        return platform == PlatformEnum.WINDOWS;
    }

    public static boolean isLinux() {
        return platform == PlatformEnum.LINUX;
    }

    public static boolean isMac() {
        return platform == PlatformEnum.MACOS;
    }

    private static enum PlatformEnum {
        WINDOWS,
        LINUX,
        MACOS,
        UNKNOWN;

    }
}

