/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbsWebHandlerMethodInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbsWebHandlerMethodInterceptor.class);

    public abstract boolean preHandleByHandlerMethod(HttpServletRequest var1, HttpServletResponse var2, Object var3) throws Exception;

    public abstract void postHandleByHandlerMethod(HttpServletRequest var1, HttpServletResponse var2, Object var3, ModelAndView var4) throws Exception;

    public abstract void afterCompletionByHandlerMethod(HttpServletRequest var1, HttpServletResponse var2, Object var3, Exception var4) throws Exception;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            return this.preHandleByHandlerMethod(request, response, handler);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.postHandleByHandlerMethod(request, response, handler, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.afterCompletionByHandlerMethod(request, response, handler, ex);
        }
    }

    protected byte[] readRequestData(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ServletInputStream in = request.getInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)bout);
            try {
                in.reset();
            }
            catch (IOException ex) {
                log.error("Failed to reset input stream.", (Throwable)ex);
            }
        }
        return bout.toByteArray();
    }

    protected String getLanguage(HttpServletRequest request) {
        String languageParams = request.getParameter("Language");
        if (Objects.nonNull(languageParams) && !"".equals(languageParams)) {
            return languageParams;
        }
        Object language = request.getSession().getAttribute("Language");
        if (Objects.nonNull(language) && !"".equals(language)) {
            return String.valueOf(language);
        }
        String languageInCookie = this.getCookieAsString(request, "Language");
        if (Objects.nonNull(languageInCookie)) {
            return languageInCookie;
        }
        String headerLanguage = request.getHeader("Language");
        if (Objects.nonNull(headerLanguage)) {
            return headerLanguage;
        }
        return "en";
    }

    private String getCookieAsString(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies)) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                return cookies[i].getValue();
            }
        }
        return null;
    }
}

