/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import com.alibaba.ttl.TransmittableThreadLocal;
import io.github.novareseller.boot.interceptor.AbsWebHandlerMethodInterceptor;
import io.github.novareseller.boot.interceptor.HttpLogHandler;
import io.github.novareseller.boot.utils.HttpUtils;
import io.github.novareseller.log.context.LogContext;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
extends AbsWebHandlerMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private final TransmittableThreadLocal<StopWatch> invokeTimeTL = new TransmittableThreadLocal();

    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String ip = HttpUtils.getRemoteHost(request);
        String language = this.getLanguage(request);
        byte[] data = this.readRequestData(request);
        String text = data == null ? "" : new String(data, StandardCharsets.UTF_8);
        HttpLogHandler.loadInstance().preHandle(request, response, null);
        response.addHeader("Trace-Id", LogContext.getTraceId());
        if (LogContext.enableInvokeTimePrint()) {
            StopWatch stopWatch = new StopWatch();
            this.invokeTimeTL.set((Object)stopWatch);
            stopWatch.start();
        }
        log.info("http request: uri={}, method={}, ip={}, language={}, data={}", new Object[]{uri, method, ip, language, text});
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (LogContext.enableInvokeTimePrint()) {
            StopWatch stopWatch = (StopWatch)this.invokeTimeTL.get();
            stopWatch.stop();
            log.info("End the call of URI[{}]. Time-consuming: {} milliseconds", (Object)request.getRequestURI(), (Object)stopWatch.getTime());
            this.invokeTimeTL.remove();
        }
        HttpLogHandler.loadInstance().afterCompletion(request, response, handler);
    }
}

