/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import cn.hutool.core.net.NetUtil;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseGlobalInterceptor;
import io.github.novareseller.log.context.LogContext;
import io.github.novareseller.log.context.SpanIdGenerator;
import io.github.novareseller.tool.utils.Validator;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RetrofitTraceInterceptor
extends BaseGlobalInterceptor {
    @Value(value="${spring.application.name}")
    private String appName;

    protected Response doIntercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String traceId = LogContext.getTraceId();
        if (Validator.isNullOrEmpty((Object)traceId)) {
            return chain.proceed(request);
        }
        String localHostName = NetUtil.getLocalHostName();
        String preIp = LogContext.getPreIp();
        Request newReq = request.newBuilder().addHeader("Trace-Id", Validator.isNullOrEmpty((Object)traceId) ? "NONE" : traceId).addHeader("Pre-Ivk-App", Validator.isNullOrEmpty((Object)this.appName) ? "NONE" : this.appName).addHeader("Pre-Ivk-Host", Validator.isNullOrEmpty((Object)localHostName) ? "NONE" : localHostName).addHeader("Pre-Ip", Validator.isNullOrEmpty((Object)preIp) ? "NONE" : preIp).addHeader("Span-Id", SpanIdGenerator.generateNextSpanId()).build();
        return chain.proceed(newReq);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

