/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.properties;

import io.github.novareseller.tool.utils.Validator;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.AntPathMatcher;

@ConfigurationProperties(prefix="spring.dagger.web")
public class WebProperties {
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    public static final String[] ENDPOINTS = new String[]{"/**/actuator/**", "/**/actuator/**/**", "/swagger-ui.html", "/swagger-resources/**", "/webjars/**", "/**/v2/api-docs/**", "/**/swagger-ui.html", "/**/swagger-resources/**", "/**/webjars/**", "/**/proxy.stream/**", "/**/druid/**", "/**/favicon.ico", "/**/prometheus", "/favicon.ico", "/api/ping/v1", "/static/*", "*.html", "*.js", "*.ico", "*.jpg", "*.png", "*.css"};
    private List<String> excludePathPatterns;
    private String dateFormatPattern = "yyyy-MM-dd HH:mm:ss";

    public boolean isExcludePath(String uri) {
        if (!Validator.isNullOrEmpty(this.excludePathPatterns)) {
            for (String excludePathPattern : this.excludePathPatterns) {
                if (!MATCHER.match(excludePathPattern, uri)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getExcludePathPatterns() {
        return this.excludePathPatterns;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setExcludePathPatterns(List<String> excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }
}

