/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.github.novareseller.tool.utils.Validator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static ImmutableList<String> ipHeaderNameList = ImmutableList.builder().add((Object)"x-forwarded-for").add((Object)"CF-Connecting-IP").add((Object)"Proxy-Client-IP").add((Object)"WL-Proxy-Client-IP").add((Object)"X-Forwarded-For").add((Object)"HTTP_X_REAL_IP").add((Object)"HTTP_CLIENT_IP").add((Object)"HTTP_X_FORWARDED_FOR").build();

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty((String)clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String headerName;
        String remoteHost = null;
        UnmodifiableIterator unmodifiableIterator = ipHeaderNameList.iterator();
        while (unmodifiableIterator.hasNext() && !HttpUtils.isInvalidClientIp(remoteHost = request.getHeader(headerName = (String)unmodifiableIterator.next()))) {
        }
        if (!HttpUtils.isInvalidClientIp(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteHost) && remoteHost.length() > 15 && remoteHost.indexOf(",") > 0) {
            remoteHost = remoteHost.substring(0, remoteHost.indexOf(","));
        }
        return Strings.nullToEmpty((String)remoteHost);
    }

    public static String getClientRegion(HttpServletRequest request) {
        return Strings.nullToEmpty((String)request.getHeader("CF-IPCountry"));
    }

    public static String getClientAddr(HttpServletRequest request, Set<String> headers) {
        String headerName;
        String remoteAddr = null;
        Iterator<String> iterator = headers.iterator();
        while (iterator.hasNext() && !HttpUtils.isInvalidClientIp(remoteAddr = request.getHeader(headerName = iterator.next()))) {
        }
        if (!HttpUtils.isInvalidClientIp(remoteAddr)) {
            remoteAddr = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteAddr) && remoteAddr.indexOf(",") > 0) {
            remoteAddr = remoteAddr.substring(0, remoteAddr.indexOf(","));
        }
        return Strings.nullToEmpty((String)remoteAddr);
    }

    public static String getLastProxyAddr(HttpServletRequest request, List<String> headers) {
        int pos;
        String remoteAddr = "";
        if (!Validator.isNullOrEmpty(headers)) {
            String headerName;
            Iterator<String> iterator = headers.iterator();
            while (iterator.hasNext() && !HttpUtils.isInvalidClientIp(remoteAddr = request.getHeader(headerName = iterator.next()))) {
            }
        }
        if (Strings.isNullOrEmpty((String)remoteAddr) && !Strings.isNullOrEmpty((String)(remoteAddr = Strings.nullToEmpty((String)request.getRemoteAddr())))) {
            return remoteAddr;
        }
        if (!Strings.isNullOrEmpty((String)remoteAddr) && (pos = Strings.nullToEmpty((String)remoteAddr).lastIndexOf(",")) > 0) {
            remoteAddr = remoteAddr.substring(pos);
        }
        return remoteAddr;
    }
}

