package io.github.novareseller.boot.interceptor;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BasePathMatchInterceptor;
import io.github.novareseller.boot.constant.WebConst;
import io.github.novareseller.boot.utils.SpringUtils;
import io.github.novareseller.security.helper.ClientAuthorizationHelper;
import io.github.novareseller.security.model.TenantInfo;
import io.github.novareseller.security.spi.TenantInfoHolder;
import io.github.novareseller.tool.text.StringUtil;
import io.github.novareseller.tool.utils.SystemClock;
import io.github.novareseller.tool.utils.Validator;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * @author: Bowen huang
 * @date: 2021/05/17
 */
@Component
@Slf4j
public class TenantSignInterceptor extends BasePathMatchInterceptor {

    private static final String TENANT_HEADER = "tenantId";

    @Override
    protected Response doIntercept(Chain chain) throws IOException {

        Request request = chain.request();

        TenantInfoHolder holder = SpringUtils.getBean(TenantInfoHolder.class);

        String tenantId = request.header(TENANT_HEADER);

        if (Validator.isNullOrEmpty(tenantId)) {
            throw new RuntimeException("tenantId parameter is missing in header");
        }

        TenantInfo tenantInfo = holder.findTenantInfo(Long.parseLong(tenantId));

        RequestBody requestBody = request.body();

        String authorization = StringUtil.EMPTY;
        long ts = SystemClock.now();
        try {
            if ( requestBody != null ) {
                Buffer buffer = new Buffer();
                requestBody.writeTo(buffer);
                byte[] data = buffer.readByteArray();
                authorization = ClientAuthorizationHelper.createAuthorization(ts, String.valueOf(tenantInfo.getId()), tenantInfo.getSecretKey(), data);
            } else {
                authorization = ClientAuthorizationHelper.createAuthorization(ts, String.valueOf(tenantInfo.getId()), tenantInfo.getSecretKey(), new byte[0]);
            }
        } catch (Exception e) {
            log.error("Client Sign Exception, ex={}", ExceptionUtil.stacktraceToString(e));
        }

        Request newReq = request.newBuilder()
                .addHeader(WebConst.HEADER_TENANT_AUTHORIZATION, authorization)
                .build();

        return chain.proceed(newReq);
    }
}
