/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import io.github.novareseller.boot.filter.CachingRequestContentFilter;
import io.github.novareseller.boot.interceptor.LogInterceptor;
import io.github.novareseller.boot.interceptor.TenantAuthInterceptor;
import io.github.novareseller.boot.interceptor.UserAuthInterceptor;
import io.github.novareseller.boot.properties.WebProperties;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class})
@ConditionalOnClass(value={WebMvcConfigurer.class})
@EnableWebMvc
@ComponentScan(basePackages={"io.github.novareseller"})
public class WebMvcConfig
implements WebMvcConfigurer {
    @Autowired
    private WebProperties webProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new LogInterceptor()).addPathPatterns(new String[]{"/api/**"}).excludePathPatterns(WebProperties.ENDPOINTS);
        registry.addInterceptor((HandlerInterceptor)new UserAuthInterceptor(this.webProperties.getExcludePathPatterns())).addPathPatterns(new String[]{"/api/**"});
        registry.addInterceptor((HandlerInterceptor)new TenantAuthInterceptor()).addPathPatterns(new String[]{"/api/**"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.webProperties.getDateFormatPattern()));
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(mapper);
        converters.add(0, (HttpMessageConverter<?>)converter);
    }

    @Bean(value={"requestFilterRegistrationBean"})
    public FilterRegistrationBean<CachingRequestContentFilter> requestFilterRegistrationBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CachingRequestContentFilter(this.webProperties.getExcludePathPatterns()));
        bean.addUrlPatterns(new String[]{"/api/*"});
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.dagger.web.enable-kaptcha"}, havingValue="true")
    public DefaultKaptcha captchaProducer() {
        DefaultKaptcha captchaProducer = new DefaultKaptcha();
        Properties properties = new Properties();
        properties.setProperty("kaptcha.border", "yes");
        properties.setProperty("kaptcha.border.color", "105,179,90");
        properties.setProperty("kaptcha.textproducer.font.color", "red");
        properties.setProperty("kaptcha.image.width", "131");
        properties.setProperty("kaptcha.image.height", "46");
        properties.setProperty("kaptcha.textproducer.font.size", "38");
        properties.setProperty("kaptcha.session.key", "code");
        properties.setProperty("kaptcha.textproducer.char.length", "4");
        properties.setProperty("kaptcha.textproducer.font.names", "\u5b8b\u4f53,\u6977\u4f53,\u5fae\u8f6f\u96c5\u9ed1");
        Config config = new Config(properties);
        captchaProducer.setConfig(config);
        return captchaProducer;
    }
}

