/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.filter;

import io.github.novareseller.boot.wrapper.MultipleReadHttpRequestWrapper;
import io.github.novareseller.tool.utils.Validator;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class CachingRequestContentFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CachingRequestContentFilter.class);
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private List<String> excludePathPatterns;

    public CachingRequestContentFilter(List<String> excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String uri = httpServletRequest.getRequestURI();
        if (!this.isExcludePath(uri)) {
            httpServletRequest = new MultipleReadHttpRequestWrapper((HttpServletRequest)httpServletRequest);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isExcludePath(String uri) {
        if (!Validator.isNullOrEmpty(this.excludePathPatterns)) {
            for (String excludePathPattern : this.excludePathPatterns) {
                if (!MATCHER.match(excludePathPattern, uri)) continue;
                return true;
            }
        }
        return false;
    }
}

