/*
 * Decompiled with CFR 0.152.
 */
package io.github.novareseller.boot.interceptor;

import io.github.novareseller.boot.interceptor.AbsWebHandlerMethodInterceptor;
import io.github.novareseller.boot.utils.HttpUtils;
import io.github.novareseller.boot.utils.JsonUtils;
import io.github.novareseller.boot.utils.ResponseUtils;
import io.github.novareseller.boot.utils.SpringUtils;
import io.github.novareseller.boot.wrapper.ApiResponse;
import io.github.novareseller.boot.wrapper.MultipleReadHttpRequestWrapper;
import io.github.novareseller.security.annotation.VerifyClient;
import io.github.novareseller.security.helper.ClientAuthorizationHelper;
import io.github.novareseller.security.model.ClientInfo;
import io.github.novareseller.security.spi.ClientInfoHolder;
import io.github.novareseller.tool.utils.Validator;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class ClientAuthInterceptor
extends AbsWebHandlerMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthInterceptor.class);

    @Override
    public boolean preHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long clientId;
        long timestamp;
        if (!this.hasVerifyClientAnnotation((HandlerMethod)handler)) {
            return true;
        }
        String host = HttpUtils.getRemoteHost(request);
        String region = HttpUtils.getClientRegion(request);
        String uri = request.getRequestURI();
        String method = request.getMethod();
        byte[] data = this.readRequestData(request);
        String authorization = request.getHeader("X-Client-Authorization");
        if (Validator.isNullOrEmpty((Object)authorization)) {
            log.error("Authorization required: uri={}, host={}", (Object)uri, (Object)host);
            this.responseError(response, "Authorization required.");
            return false;
        }
        String[] ss = authorization.split(";");
        if (ss.length != 4) {
            log.error("Invalid authorization: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Invalid authorization format");
            return false;
        }
        try {
            timestamp = Long.parseLong(ss[1]);
            clientId = Integer.parseInt(ss[2]);
        }
        catch (Exception ex) {
            log.error("Invalid authorization format: uri={}, host={}, authorization={}, timestamp={}, clientId={}", new Object[]{uri, host, authorization, ss[1], ss[2]});
            this.responseError(response, "Invalid authorization format");
            return false;
        }
        ClientInfoHolder holder = SpringUtils.getBean(ClientInfoHolder.class);
        ClientInfo clientInfo = holder.findClientInfo(Long.valueOf(clientId));
        if (clientInfo == null) {
            log.error("Invalid clientId: uri={}, host={}, authorization={}, clientId={}", new Object[]{uri, host, authorization, clientId});
            this.responseError(response, "Invalid clientId");
            return false;
        }
        if (System.currentTimeMillis() - timestamp > 300000L) {
            log.error("Authorization expired: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Authorization expired");
            return false;
        }
        boolean success = ClientAuthorizationHelper.verifyAuthorization((String)String.valueOf(clientId), (String)clientInfo.getSecretKey(), (byte[])data, (String)authorization);
        if (!success) {
            log.error("Authorization failed: uri={}, host={}, authorization={}", new Object[]{uri, host, authorization});
            this.responseError(response, "Invalid authorization");
            return false;
        }
        request.setAttribute("clientId", (Object)clientInfo.getId());
        String id = String.format("%08x", request.hashCode());
        log.info("API request[{}]: method={}, uri={}, host={}, region={}, authorization={}, content-length={}", new Object[]{id, method, uri, host, region, authorization, data.length});
        return true;
    }

    @Override
    public void postHandleByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletionByHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.hasVerifyClientAnnotation((HandlerMethod)handler) && request instanceof MultipleReadHttpRequestWrapper) {
            String id = String.format("%08x", request.hashCode());
            log.info("API completed[{}]: status={}, contentType={}", new Object[]{id, response.getStatus(), response.getContentType()});
        }
    }

    private boolean hasVerifyClientAnnotation(HandlerMethod handlerMethod) {
        VerifyClient annotation = handlerMethod.getBeanType().getAnnotation(VerifyClient.class);
        if (annotation == null) {
            annotation = (VerifyClient)handlerMethod.getMethodAnnotation(VerifyClient.class);
        }
        return annotation != null;
    }

    private void responseError(HttpServletResponse response, String message) throws Exception {
        ApiResponse error = ResponseUtils.error(-24031, message);
        String json = JsonUtils.json(error);
        byte[] data = json.getBytes(StandardCharsets.UTF_8);
        response.setStatus(401);
        response.setContentType("application/json;charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }
}

